/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.logout.profile.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.logout.profile.impl.AbstractOIDCRpInitiatedLogoutAction;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCRpInitiatedLogoutContext;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateIdTokenHint
extends AbstractOIDCRpInitiatedLogoutAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateIdTokenHint.class);
    @Nullable
    private JWT idTokenHint;
    @NonnullAfterInit
    private ClaimsValidator claimsValidator;

    public void setClaimsValidator(@Nonnull ClaimsValidator validator) {
        this.checkSetterPreconditions();
        this.claimsValidator = (ClaimsValidator)Constraint.isNotNull((Object)validator, (String)"Claims validator cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.claimsValidator == null) {
            throw new ComponentInitializationException("ClaimsValidator for ID token hints cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        OIDCRpInitiatedLogoutContext rpInitiatedLogoutContext = this.getRpInitiatedLogoutContext();
        assert (rpInitiatedLogoutContext != null);
        this.idTokenHint = rpInitiatedLogoutContext.getProcessedIdTokenHint();
        if (this.idTokenHint == null) {
            this.log.debug("{} No ID token hint, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        JWT jWT = this.idTokenHint;
        if (jWT instanceof SignedJWT) {
            SignedJWT signedJwt = (SignedJWT)jWT;
            try {
                JWTClaimsSet claimsSet = signedJwt.getJWTClaimsSet();
                assert (claimsSet != null);
                this.claimsValidator.validate(claimsSet, profileRequestContext);
            }
            catch (ParseException | JWTValidationException e) {
                this.log.warn("{} JWT validation failed: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidIdTokenHint");
                return;
            }
        } else {
            this.log.error("{} ID token hint is not signed", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidIdTokenHint");
            return;
        }
    }
}

