/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.logout.profile.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.text.ParseException;
import java.util.Iterator;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.plugin.oidc.op.logout.profile.impl.AbstractOIDCRpInitiatedLogoutAction;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCRpInitiatedLogoutContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.LogoutRequestClientIDLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.session.OIDCRPSession;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SessionResolver;
import net.shibboleth.idp.session.context.LogoutContext;
import net.shibboleth.idp.session.context.SessionContext;
import net.shibboleth.idp.session.criterion.HttpServletRequestCriterion;
import net.shibboleth.idp.session.criterion.SPSessionCriterion;
import net.shibboleth.oidc.profile.config.navigate.LogoutHintMatchingStrategyLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class ProcessRpInitiatedLogoutRequest
extends AbstractOIDCRpInitiatedLogoutAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProcessRpInitiatedLogoutRequest.class);
    @NonnullAfterInit
    private SessionResolver sessionResolver;
    @Nonnull
    private Function<ProfileRequestContext, SubjectContext> subjectContextCreationStrategy = new ChildContextLookup(SubjectContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, SessionContext> sessionContextCreationStrategy = new ChildContextLookup(SessionContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, LogoutContext> logoutContextCreationStrategy = new ChildContextLookup(LogoutContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, ClientID> issuerLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, CriteriaSet> sessionResolverCriteriaStrategy;
    @Nonnull
    private Function<ProfileRequestContext, BiPredicate<String, SPSession>> logoutHintMatchingStrategyLookupStrategy;

    public ProcessRpInitiatedLogoutRequest() {
        Function ils = new LogoutRequestClientIDLookupFunction().compose((Function)new InboundMessageContextLookup());
        assert (ils != null);
        this.issuerLookupStrategy = ils;
        this.sessionResolverCriteriaStrategy = new Function<ProfileRequestContext, CriteriaSet>(){

            @Override
            public CriteriaSet apply(ProfileRequestContext input) {
                ClientID clientID = ProcessRpInitiatedLogoutRequest.this.issuerLookupStrategy.apply(input);
                OIDCRpInitiatedLogoutContext rpInitiatedLogoutContext = ProcessRpInitiatedLogoutRequest.this.getRpInitiatedLogoutContext();
                assert (rpInitiatedLogoutContext != null);
                JWT processedIdTokenHint = rpInitiatedLogoutContext.getProcessedIdTokenHint();
                if (clientID != null && processedIdTokenHint != null) {
                    String clientIdValue = clientID.getValue();
                    assert (clientIdValue != null);
                    ProcessRpInitiatedLogoutRequest.this.log.debug("{} Building criteria set with clientID {} and idTokenHint {}", new Object[]{ProcessRpInitiatedLogoutRequest.this.getLogPrefix(), clientIdValue, processedIdTokenHint});
                    try {
                        String sessionId = processedIdTokenHint.getJWTClaimsSet().getStringClaim("sid");
                        if (sessionId != null) {
                            return new CriteriaSet(new Criterion[]{new SPSessionCriterion(clientIdValue, sessionId)});
                        }
                    }
                    catch (ParseException e) {
                        ProcessRpInitiatedLogoutRequest.this.log.error("{} Could not parse session ID from id_token_hint", (Object)ProcessRpInitiatedLogoutRequest.this.getLogPrefix(), (Object)e);
                    }
                }
                ProcessRpInitiatedLogoutRequest.this.log.debug("{} Building criteria set with HttpServletRequestCriterion", (Object)ProcessRpInitiatedLogoutRequest.this.getLogPrefix());
                return new CriteriaSet(new Criterion[]{new HttpServletRequestCriterion()});
            }
        };
        this.logoutHintMatchingStrategyLookupStrategy = new LogoutHintMatchingStrategyLookupFunction();
    }

    public void setSessionResolver(@Nonnull SessionResolver resolver) {
        this.checkSetterPreconditions();
        this.sessionResolver = (SessionResolver)Constraint.isNotNull((Object)resolver, (String)"SessionResolver cannot be null");
    }

    public void setSubjectContextCreationStrategy(@Nonnull Function<ProfileRequestContext, SubjectContext> strategy) {
        this.checkSetterPreconditions();
        this.subjectContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectContext creation strategy cannot be null");
    }

    public void setSessionContextCreationStrategy(@Nonnull Function<ProfileRequestContext, SessionContext> strategy) {
        this.checkSetterPreconditions();
        this.sessionContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionContext creation strategy cannot be null");
    }

    public void setLogoutContextCreationStrategy(@Nonnull Function<ProfileRequestContext, LogoutContext> strategy) {
        this.checkSetterPreconditions();
        this.logoutContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutContext creation strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, ClientID> strategy) {
        this.checkSetterPreconditions();
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    public void setSessionResolverCriteriaStrategy(@Nonnull Function<ProfileRequestContext, CriteriaSet> strategy) {
        this.checkSetterPreconditions();
        this.sessionResolverCriteriaStrategy = (Function)Constraint.isNotNull(strategy, (String)"SessionResolver CriteriaSet strategy cannot be null");
    }

    public void setLogoutHintMatchingStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiPredicate<String, SPSession>> strategy) {
        this.checkSetterPreconditions();
        this.logoutHintMatchingStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutHintMatchingStrategy lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (!PredicateSupport.isAlwaysFalse((Predicate)this.getActivationCondition()) && this.sessionResolver == null) {
            throw new ComponentInitializationException("SessionResolver cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            SessionContext sessionCtx;
            Iterable sessions = this.sessionResolver.resolve((Object)this.sessionResolverCriteriaStrategy.apply(profileRequestContext));
            Iterator sessionIterator = sessions.iterator();
            LogoutContext logoutCtx = null;
            int count = 1;
            this.log.debug("{} Has next? {}", (Object)this.getLogPrefix(), (Object)sessionIterator.hasNext());
            while (sessionIterator.hasNext()) {
                IdPSession session = (IdPSession)sessionIterator.next();
                assert (session != null);
                if (!this.sessionMatches(profileRequestContext, session)) {
                    this.log.debug("{} IdP session {} does not contain a matching SP session", (Object)this.getLogPrefix(), (Object)session.getId());
                    continue;
                }
                this.log.debug("{} LogoutRequest matches IdP session {}", (Object)this.getLogPrefix(), (Object)session.getId());
                if (logoutCtx == null) {
                    logoutCtx = this.logoutContextCreationStrategy.apply(profileRequestContext);
                    if (logoutCtx == null) {
                        this.log.error("{} Unable to create or locate LogoutContext", (Object)this.getLogPrefix());
                        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
                        return;
                    }
                    SubjectContext subjectCtx = this.subjectContextCreationStrategy.apply(profileRequestContext);
                    if (subjectCtx != null) {
                        subjectCtx.setPrincipalName(session.getPrincipalName());
                    }
                }
                logoutCtx.getIdPSessions().add(session);
                for (SPSession spSession : session.getSPSessions()) {
                    assert (spSession != null);
                    if (!this.sessionMatches(profileRequestContext, spSession) || ((OIDCRPSession)spSession).supportsLogoutPropagation()) {
                        logoutCtx.getSessionMap().put((Object)spSession.getId(), (Object)spSession);
                        logoutCtx.getKeyedSessionMap().put(Integer.toString(count++), spSession);
                        continue;
                    }
                    this.log.debug("{} Skipping {} when popoulating the logout context", (Object)this.getLogPrefix(), (Object)spSession.getId());
                }
            }
            if (logoutCtx == null) {
                this.log.info("{} No active session(s) found matching LogoutRequest", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"SessionNotFound");
            } else if (logoutCtx.getIdPSessions().size() == 1 && (sessionCtx = this.sessionContextCreationStrategy.apply(profileRequestContext)) != null) {
                sessionCtx.setIdPSession((IdPSession)logoutCtx.getIdPSessions().iterator().next());
            }
        }
        catch (ResolverException e) {
            this.log.error("{} Error resolving matching session(s)", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"SessionNotFound");
        }
    }

    private boolean sessionMatches(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull IdPSession session) {
        for (SPSession spSession : session.getSPSessions()) {
            assert (spSession != null);
            this.log.trace("{} Matching session with SP session key {}", (Object)this.getLogPrefix(), (Object)spSession.getSPSessionKey());
            if (!this.sessionMatches(profileRequestContext, spSession)) continue;
            return true;
        }
        return false;
    }

    private boolean sessionMatches(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SPSession session) {
        assert (this.isPreExecuteCalled());
        if (session instanceof OIDCRPSession) {
            OIDCRPSession oidcRpSession = (OIDCRPSession)session;
            ClientID issuer = this.issuerLookupStrategy.apply(profileRequestContext);
            if (issuer == null || !oidcRpSession.getId().equals(issuer.getValue())) {
                assert (issuer != null);
                this.log.trace("{} The session ID {} did not match with the issuer {}", new Object[]{this.getLogPrefix(), oidcRpSession.getId(), issuer.getValue()});
                return false;
            }
            OIDCRpInitiatedLogoutContext rpInitiatedLogoutContext = this.getRpInitiatedLogoutContext();
            assert (rpInitiatedLogoutContext != null);
            JWT idTokenHint = rpInitiatedLogoutContext.getProcessedIdTokenHint();
            if (idTokenHint != null) {
                try {
                    String subject = idTokenHint.getJWTClaimsSet().getSubject();
                    this.log.trace("{} Matching id_token_hint subject {} with session subject {}", new Object[]{this.getLogPrefix(), subject, oidcRpSession.getSubject()});
                    if (subject != null && subject.equals(oidcRpSession.getSubject())) {
                        this.log.debug("{} Found a matching session via id_token_hint subject", (Object)this.getLogPrefix());
                        return true;
                    }
                }
                catch (ParseException e) {
                    this.log.error("{} Could not parse subject from id_token_hint", (Object)this.getLogPrefix(), (Object)e);
                }
                return false;
            }
            String logoutHint = rpInitiatedLogoutContext.getLogoutHint();
            BiPredicate<String, SPSession> matchingPredicate = this.logoutHintMatchingStrategyLookupStrategy.apply(profileRequestContext);
            if (matchingPredicate != null && matchingPredicate.test(logoutHint, (SPSession)oidcRpSession)) {
                this.log.debug("{} Found a matching session via logout_hint {}", (Object)this.getLogPrefix(), (Object)logoutHint);
                return true;
            }
        }
        return false;
    }
}

