/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.authn.audit.impl;

import com.nimbusds.oauth2.sdk.auth.JWTAuthentication;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.oidc.authn.context.OAuth2ClientAuthenticationContext;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class ClientAuthenticationJWTTypeHeaderAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private Function<ProfileRequestContext, OAuth2ClientAuthenticationContext> clientAuthContextLookupStrategy;

    public ClientAuthenticationJWTTypeHeaderAuditExtractor() {
        Function cacls = new ChildContextLookup(OAuth2ClientAuthenticationContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));
        assert (cacls != null);
        this.clientAuthContextLookupStrategy = cacls;
    }

    public ClientAuthenticationJWTTypeHeaderAuditExtractor(@Nonnull @ParameterName(name="clientAuthContextLookupStrategy") Function<ProfileRequestContext, OAuth2ClientAuthenticationContext> lookupStrategy) {
        this.clientAuthContextLookupStrategy = (Function)Constraint.isNotNull(lookupStrategy, (String)"clientAuthContextLookupStrategy lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        return Optional.ofNullable(this.clientAuthContextLookupStrategy.apply(input)).map(ctx -> ctx.getClientAuthentication()).filter(JWTAuthentication.class::isInstance).map(JWTAuthentication.class::cast).map(jwtAuthentication -> jwtAuthentication.getClientAssertion()).map(jwt -> jwt.getHeader().getType()).map(joseType -> joseType.getType()).orElse(null);
    }
}

