/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.token.support;

import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;

public final class AuthorizeCodeClaimsSet
extends TokenClaimsSet {
    @Nonnull
    @NotEmpty
    public static final String VALUE_TYPE_AC = "ac";

    private AuthorizeCodeClaimsSet(@Nonnull JWTClaimsSet authzCodeClaimsSet) {
        super(authzCodeClaimsSet);
    }

    public static AuthorizeCodeClaimsSet parse(String authorizeCodeClaimsSet) throws ParseException {
        JWTClaimsSet acClaimsSet = JWTClaimsSet.parse((String)authorizeCodeClaimsSet);
        assert (acClaimsSet != null);
        AuthorizeCodeClaimsSet.verifyParsedClaims(VALUE_TYPE_AC, acClaimsSet);
        return new AuthorizeCodeClaimsSet(acClaimsSet);
    }

    public static AuthorizeCodeClaimsSet parse(@Nonnull String wrappedAuthCode, @Nonnull DataSealer dataSealer) throws ParseException, DataSealerException {
        return AuthorizeCodeClaimsSet.parse(dataSealer.unwrap(wrappedAuthCode));
    }

    public static class Builder
    extends TokenClaimsSet.Builder<AuthorizeCodeClaimsSet> {
        @Override
        public AuthorizeCodeClaimsSet build() {
            return new AuthorizeCodeClaimsSet(this.buildJWTClaimsSet(AuthorizeCodeClaimsSet.VALUE_TYPE_AC));
        }
    }
}

