/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.session;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.session.BasicSPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;

@ThreadSafe
public class OIDCRPSession
extends BasicSPSession
implements SPSession {
    @Nonnull
    @NotEmpty
    private final String issuer;
    @Nullable
    private final String rootTokenIdentifier;
    @Nonnull
    @NotEmpty
    private final String sessionIdentifier;
    @Nonnull
    @NotEmpty
    private final String subject;
    private final boolean supportsLogoutPropagation;

    private OIDCRPSession(@Nonnull @NotEmpty String id, @Nonnull Instant creation, @Nonnull Instant expiration, @Nonnull @NotEmpty String iss, @Nullable String rootJti, @Nonnull @NotEmpty String sid, @Nonnull @NotEmpty String sub, boolean supportsPropagation) {
        super(id, creation, expiration);
        this.issuer = Constraint.isNotEmpty((String)iss, (String)"The issuer value cannot be empty");
        this.rootTokenIdentifier = rootJti;
        this.sessionIdentifier = Constraint.isNotEmpty((String)sid, (String)"The session identifier cannot be empty");
        this.subject = Constraint.isNotEmpty((String)sub, (String)"The subject value cannot be empty");
        this.supportsLogoutPropagation = supportsPropagation;
    }

    @Nonnull
    @NotEmpty
    public String getSPSessionKey() {
        return this.sessionIdentifier;
    }

    @Nonnull
    @NotEmpty
    public String getProtocol() {
        return "http://openid.net/specs/openid-connect-core-1_0.html";
    }

    @Nonnull
    @NotEmpty
    public String getIssuer() {
        return this.issuer;
    }

    @Nullable
    @NotEmpty
    public String getRootTokenIdentifier() {
        return this.rootTokenIdentifier;
    }

    @Nonnull
    @NotEmpty
    public String getSessionIdentifier() {
        return this.sessionIdentifier;
    }

    @Nonnull
    @NotEmpty
    public String getSubject() {
        return this.subject;
    }

    public boolean supportsLogoutPropagation() {
        return this.supportsLogoutPropagation;
    }

    public static class Builder {
        @Nullable
        private String serviceId;
        @Nullable
        private Instant creationInstant;
        @Nullable
        private Instant expirationInstant;
        @Nullable
        private String issuer;
        @Nullable
        private String rootTokenIdentifier;
        @Nullable
        private String sessionIdentifier;
        @Nullable
        private String subject;
        private boolean supportsLogoutPropagation;

        public Builder serviceId(@Nonnull String id) {
            this.serviceId = id;
            return this;
        }

        public Builder creationInstant(@Nonnull Instant creation) {
            this.creationInstant = creation;
            return this;
        }

        public Builder expirationInstant(@Nonnull Instant expiration) {
            this.expirationInstant = expiration;
            return this;
        }

        public Builder issuer(@Nonnull String iss) {
            this.issuer = iss;
            return this;
        }

        public Builder rootTokenIdentifier(@Nullable String rootJti) {
            this.rootTokenIdentifier = rootJti;
            return this;
        }

        public Builder sessionIdentifier(@Nonnull String sid) {
            this.sessionIdentifier = sid;
            return this;
        }

        public Builder subject(@Nonnull String sub) {
            this.subject = sub;
            return this;
        }

        public Builder supportLogoutPropagation(boolean supportsPropagation) {
            this.supportsLogoutPropagation = supportsPropagation;
            return this;
        }

        @Nonnull
        public OIDCRPSession build() {
            Constraint.isNotEmpty((String)this.serviceId, (String)"The serviceId value cannot be empty");
            Constraint.isNotNull((Object)this.creationInstant, (String)"The creationInstant value cannot be null");
            Constraint.isNotNull((Object)this.expirationInstant, (String)"The expirationInstant value cannot be null");
            Constraint.isNotEmpty((String)this.issuer, (String)"The issuer value cannot be empty");
            Constraint.isNotEmpty((String)this.sessionIdentifier, (String)"The session identifier cannot be empty");
            Constraint.isNotEmpty((String)this.subject, (String)"The subject value cannot be empty");
            assert (this.serviceId != null);
            assert (this.creationInstant != null);
            assert (this.expirationInstant != null);
            assert (this.issuer != null);
            assert (this.sessionIdentifier != null);
            assert (this.subject != null);
            return new OIDCRPSession(this.serviceId, this.creationInstant, this.expirationInstant, this.issuer, this.rootTokenIdentifier, this.sessionIdentifier, this.subject, this.supportsLogoutPropagation);
        }
    }
}

