/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.LogoutRequest;
import java.text.ParseException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.slf4j.Logger;

public class LogoutRequestClientIDLookupFunction
implements ContextDataLookupFunction<MessageContext, ClientID> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LogoutRequestClientIDLookupFunction.class);

    @Nullable
    public ClientID apply(@Nullable MessageContext input) {
        if (input == null) {
            return null;
        }
        Object object = input.getMessage();
        if (object instanceof LogoutRequest) {
            LogoutRequest logoutRequest = (LogoutRequest)object;
            ClientID requestClientId = logoutRequest.getClientID();
            JWT idTokenHint = logoutRequest.getIDTokenHint();
            if (requestClientId == null && idTokenHint instanceof EncryptedJWT) {
                this.log.error("id_token_hint is encrypted and no client_id found in request, no client_id resolved");
                return null;
            }
            if (idTokenHint instanceof SignedJWT) {
                SignedJWT signedJwt = (SignedJWT)idTokenHint;
                String idTokenClientId = this.getClientIdFromJwt(signedJwt);
                if (idTokenClientId == null) {
                    return null;
                }
                if (requestClientId != null) {
                    if (requestClientId.toString().equals(idTokenClientId)) {
                        return requestClientId;
                    }
                    this.log.error("The client_id in id_token_hint {} did not match with the requested client_id {}", (Object)idTokenClientId, (Object)requestClientId);
                    return null;
                }
                return new ClientID(idTokenClientId);
            }
            return requestClientId;
        }
        return null;
    }

    @Nullable
    protected String getClientIdFromJwt(SignedJWT jwt) {
        try {
            List audience = jwt.getJWTClaimsSet().getAudience();
            if (audience == null || audience.isEmpty()) {
                this.log.error("No audience defined in the id_token_hint");
                return null;
            }
            if (audience.size() > 1) {
                this.log.warn("The id_token_hint contained multiple audience ({}), returning first {}", (Object)audience.size(), audience.get(0));
            }
            return (String)audience.get(0);
        }
        catch (ParseException e) {
            this.log.error("Could not parse the claims set from id_token_hint", (Throwable)e);
            return null;
        }
    }
}

