/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.context.logic;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.claims.LogoutTokenClaimsSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCBackChannelLogoutPropagationContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCLogoutPropagationContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.slf4j.Logger;

public class JWTClaimsSetFromLogoutContextLookupFunction
implements Function<MessageContext, JWTClaimsSet> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(JWTClaimsSetFromLogoutContextLookupFunction.class);
    @Nonnull
    private Function<MessageContext, OIDCBackChannelLogoutPropagationContext> logoutContextLookupStrategy;

    public JWTClaimsSetFromLogoutContextLookupFunction() {
        Function lcls = new ChildContextLookup(OIDCBackChannelLogoutPropagationContext.class).compose((Function)new ChildContextLookup(OIDCLogoutPropagationContext.class));
        assert (lcls != null);
        this.logoutContextLookupStrategy = lcls;
    }

    public void setLogoutContextLookupStrategy(@Nonnull Function<MessageContext, OIDCBackChannelLogoutPropagationContext> strategy) {
        this.logoutContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCBackChannelLogoutContext lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public JWTClaimsSet apply(@Nullable MessageContext messageContext) {
        if (messageContext == null) {
            return null;
        }
        OIDCBackChannelLogoutPropagationContext tokenCtx = this.logoutContextLookupStrategy.apply(messageContext);
        if (tokenCtx == null) {
            return null;
        }
        LogoutTokenClaimsSet claimsSet = tokenCtx.getLogoutTokenClaimsSet();
        try {
            if (claimsSet != null) {
                return claimsSet.toJWTClaimsSet();
            }
        }
        catch (ParseException e) {
            this.log.error("Could not fetch the claims set from the logout context token claims set", (Throwable)e);
        }
        return null;
    }
}

