/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.context.logic;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.slf4j.Logger;

public class JWTClaimsSetFromIDTokenLookupFunction
implements Function<MessageContext, JWTClaimsSet> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(JWTClaimsSetFromIDTokenLookupFunction.class);

    @Override
    @Nullable
    public JWTClaimsSet apply(@Nullable MessageContext messageContext) {
        if (messageContext == null) {
            return null;
        }
        OIDCAuthenticationResponseContext oidcResponseCtx = (OIDCAuthenticationResponseContext)messageContext.getSubcontext(OIDCAuthenticationResponseContext.class);
        if (oidcResponseCtx == null) {
            return null;
        }
        IDTokenClaimsSet claimsSet = oidcResponseCtx.getIDToken();
        try {
            if (claimsSet != null) {
                return claimsSet.toJWTClaimsSet();
            }
        }
        catch (ParseException e) {
            this.log.error("Could not fetch the claims set from ID token", (Throwable)e);
        }
        return null;
    }
}

