/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;

public class ProfileResponderIdLookupFunction
extends AbstractIdentifiableInitializableComponent
implements ContextDataLookupFunction<ProfileRequestContext, String> {
    @NonnullAfterInit
    private String defaultResponder;
    @Nonnull
    private Map<String, String> profileResponders = new HashMap<String, String>();

    public void setDefaultResponder(@Nonnull String resp) {
        this.defaultResponder = (String)Constraint.isNotNull((Object)resp, (String)"Default responder cannot be null");
    }

    public void setProfileResponders(@Nullable Map<ProfileConfiguration, String> resp) {
        this.profileResponders.clear();
        if (resp != null) {
            for (Map.Entry<ProfileConfiguration, String> entry : resp.entrySet()) {
                if (entry.getKey() == null || entry.getKey().getId() == null || entry.getValue() == null) continue;
                this.profileResponders.put(entry.getKey().getId(), entry.getValue());
            }
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.defaultResponder == null) {
            throw new ComponentInitializationException("Default responder cannot be null");
        }
    }

    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        if (input != null && this.profileResponders.containsKey(input.getProfileId())) {
            return this.profileResponders.get(input.getProfileId());
        }
        return this.defaultResponder;
    }
}

