/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationMetadataPolicyContext;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;

public class OIDCPolicyEnforcedClientRegistrationRequestMetadataLookupFunction
implements ContextDataLookupFunction<ProfileRequestContext, OIDCClientMetadata> {
    @Nonnull
    private Function<ProfileRequestContext, OIDCClientRegistrationMetadataPolicyContext> registrationMetadataPolicyContextLookupStrategy;

    public OIDCPolicyEnforcedClientRegistrationRequestMetadataLookupFunction() {
        Function rmpcls = new ChildContextLookup(OIDCClientRegistrationMetadataPolicyContext.class, false).compose((Function)new InboundMessageContextLookup());
        assert (rmpcls != null);
        this.registrationMetadataPolicyContextLookupStrategy = rmpcls;
    }

    public void setRegistrationMetadataPolicyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientRegistrationMetadataPolicyContext> strategy) {
        this.registrationMetadataPolicyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Registration metadata policy context lookup strategy cannot be null");
    }

    @Nullable
    public OIDCClientMetadata apply(ProfileRequestContext input) {
        OIDCClientRegistrationMetadataPolicyContext registrationMetadataPolicyContext = this.registrationMetadataPolicyContextLookupStrategy.apply(input);
        if (registrationMetadataPolicyContext != null) {
            return registrationMetadataPolicyContext.getPolicyEnforcedMetadata();
        }
        return null;
    }
}

