/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl.AbstractOIDCUserInfoValidationResponseAction;
import net.shibboleth.oidc.security.impl.JWTSignatureValidationUtil;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.slf4j.Logger;

public class ParseAccessToken
extends AbstractOIDCUserInfoValidationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ParseAccessToken.class);
    @NonnullAfterInit
    private DataSealer dataSealer;
    @Nullable
    private CredentialResolver credentialResolver;
    @NonnullAfterInit
    private Predicate<ProfileRequestContext> dpopAccessTokenCondition;
    @Nullable
    private SignedJWT signedJWT;

    public void setDataSealer(@Nonnull DataSealer sealer) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
    }

    public void setCredentialResolver(@Nullable CredentialResolver resolver) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.credentialResolver = resolver;
    }

    public void setDpopAccessTokenCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.dpopAccessTokenCondition = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.dataSealer == null) {
            throw new ComponentInitializationException("DataSealer cannot be null");
        }
        if (this.dpopAccessTokenCondition == null) {
            throw new ComponentInitializationException("DPoP access token condition cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String invalidTokenId = this.dpopAccessTokenCondition.test(profileRequestContext) ? "InvalidDPoPAccessToken" : "InvalidAcessToken";
        AccessToken token = this.getUserInfoRequest().getAccessToken();
        if (token == null) {
            this.log.error("{} Token missing from request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)invalidTokenId);
            return;
        }
        AccessTokenClaimsSet accessTokenClaimsSet = this.parseAccessToken(token);
        if (accessTokenClaimsSet == null) {
            this.log.warn("{} Unable to parse/decode token for validation", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)invalidTokenId);
            return;
        }
        this.log.debug("{} Access token unwrapped: {}", (Object)this.getLogPrefix(), (Object)accessTokenClaimsSet.serialize());
        if (this.signedJWT != null) {
            JOSEObjectType typ = this.signedJWT.getHeader().getType();
            if (typ == null || !"at+jwt".equals(typ.getType())) {
                this.log.warn("{} Missing or invalid token type: {}", (Object)this.getLogPrefix(), (Object)(typ != null ? typ.getType() : "null"));
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)invalidTokenId);
                return;
            }
            if (this.credentialResolver == null) {
                this.log.error("{} No CredentialResolver available, can't verify JWT signature", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)invalidTokenId);
                return;
            }
            this.log.debug("{} Checking JWT signature", (Object)this.getLogPrefix());
            ArrayList credList = new ArrayList();
            CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new UsageCriterion(UsageType.SIGNING)});
            try {
                assert (this.credentialResolver != null);
                Iterable creds = this.credentialResolver.resolve((Object)criteriaSet);
                creds.forEach(credList::add);
            }
            catch (ResolverException e) {
                this.log.error("{} Failure resolving signing credentials, can't verify JWT signature", (Object)this.getLogPrefix(), (Object)e);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)invalidTokenId);
                return;
            }
            assert (this.signedJWT != null);
            String errorEventId = JWTSignatureValidationUtil.validateSignatureEx(credList, (SignedJWT)this.signedJWT, (String)invalidTokenId);
            if (errorEventId != null) {
                this.log.warn("{} Signature on token ID '{}' invalid", (Object)this.getLogPrefix(), (Object)accessTokenClaimsSet.getID());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)errorEventId);
                return;
            }
        }
        this.log.debug("{} Access token {} parsed", (Object)this.getLogPrefix(), (Object)accessTokenClaimsSet.getID());
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        oidcResponseContext.setAuthorizationGrantClaimsSet((TokenClaimsSet)accessTokenClaimsSet);
    }

    @Nullable
    protected AccessTokenClaimsSet parseAccessToken(@Nonnull @NotEmpty AccessToken token) {
        String tokenValue = token.getValue();
        assert (tokenValue != null);
        try {
            this.signedJWT = SignedJWT.parse((String)tokenValue);
            assert (this.signedJWT != null);
            assert (this.dataSealer != null);
            return AccessTokenClaimsSet.parse((JWT)this.signedJWT, (DataSealer)this.dataSealer);
        }
        catch (ParseException | DataSealerException throwable) {
            try {
                assert (this.dataSealer != null);
                return AccessTokenClaimsSet.parse((String)tokenValue, (DataSealer)this.dataSealer);
            }
            catch (ParseException | DataSealerException throwable2) {
                return null;
            }
        }
    }
}

