/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl.AbstractOIDCUserInfoValidationResponseAction;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

abstract class AbstractOIDCUserInfoResponseAction
extends AbstractOIDCUserInfoValidationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractOIDCUserInfoResponseAction.class);
    @Nullable
    private OIDCMetadataContext oidcMetadataContext;

    AbstractOIDCUserInfoResponseAction() {
    }

    @Nullable
    public OIDCMetadataContext getMetadataContext() {
        return this.oidcMetadataContext;
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.oidcMetadataContext = (OIDCMetadataContext)profileRequestContext.ensureInboundMessageContext().getSubcontext(OIDCMetadataContext.class);
        if (this.oidcMetadataContext == null) {
            this.log.error("{} No metadata found for relying party", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }
}

