/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.security.jwt.claims.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.security.jwt.claims.RequestObjectClaimsValidator;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class AutowiringRequestObjectClaimsValidator
extends AbstractIdentifiableInitializableComponent
implements ClaimsValidator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AutowiringRequestObjectClaimsValidator.class);
    @Nonnull
    @NonnullElements
    private List<ClaimsValidator> initialClaimValidators;
    @Nonnull
    @NonnullElements
    private List<ClaimsValidator> claimValidators;

    @Autowired
    public AutowiringRequestObjectClaimsValidator(@Nullable Collection<RequestObjectClaimsValidator> freeObjects) {
        this.initialClaimValidators = freeObjects != null ? CollectionSupport.copyToList(freeObjects) : CollectionSupport.emptyList();
        this.claimValidators = this.initialClaimValidators;
    }

    public void setClaimValidators(@Nullable @NonnullElements List<ClaimsValidator> validators) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        if (validators != null) {
            LinkedHashSet<ClaimsValidator> holder = new LinkedHashSet<ClaimsValidator>(validators);
            holder.addAll(this.initialClaimValidators.stream().filter(obj -> {
                if (holder.contains(obj)) {
                    this.log.info("Replacing auto-wired component: {}", (Object)obj.getId());
                    return false;
                }
                return true;
            }).collect(Collectors.toUnmodifiableList()));
            this.claimValidators = CollectionSupport.copyToList(holder);
        } else {
            this.claimValidators = this.initialClaimValidators;
        }
    }

    public void validate(@Nullable JWTClaimsSet claims, @Nonnull ProfileRequestContext context) throws JWTValidationException {
        if (this.claimValidators.isEmpty()) {
            this.log.trace("{}: No validators to check, nothing to do", (Object)this.getId());
            return;
        }
        this.log.debug("{}: Attempting JWT claims validation for subject '{}'", (Object)this.getId(), (Object)claims.getSubject());
        for (ClaimsValidator validator : this.claimValidators) {
            this.log.trace("{}: Attempting JWT claims validation '{}'", (Object)this.getId(), (Object)validator.getId());
            validator.validate(claims, context);
        }
        this.log.debug("{}: JWT claims validation for subject '{}' succeeded", (Object)this.getId(), (Object)claims.getSubject());
    }
}

