/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.AbstractPushedAuthorizationRequestComponent;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;

public class StorageServicePushedAuthorizationRequestUriDeserializationFunction
extends AbstractPushedAuthorizationRequestComponent
implements BiFunction<ProfileRequestContext, URI, Map<String, Object>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StorageServicePushedAuthorizationRequestUriDeserializationFunction.class);
    @NonnullAfterInit
    private ObjectMapper objectMapper;
    @NonnullAfterInit
    private StorageService storageService;

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    public void setStorageService(@Nonnull StorageService storage) {
        this.checkSetterPreconditions();
        this.storageService = (StorageService)Constraint.isNotNull((Object)storage, (String)"StorageService cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
        if (this.storageService == null) {
            throw new ComponentInitializationException("Storage service cannot be null");
        }
    }

    @Override
    @Nullable
    public Map<String, Object> apply(@Nullable ProfileRequestContext profileRequestContext, @Nullable URI uri) {
        if (uri != null) {
            String jti = uri.toString().replace("urn:ietf:params:oauth:request_uri:ss:", "");
            assert (jti != null);
            try {
                StorageRecord storageRecord = this.storageService.read("oidcPushedAuthorizationRequests", jti);
                if (storageRecord == null) {
                    this.log.debug("Could not find any records with jti {}", (Object)jti);
                    return null;
                }
                if (this.storageService.delete("oidcPushedAuthorizationRequests", jti)) {
                    this.log.debug("Storage record {} successfully deleted", (Object)jti);
                }
                Map result = (Map)this.objectMapper.readValue(storageRecord.getValue(), (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(){});
                return result;
            }
            catch (JsonProcessingException e) {
                this.log.error("Could not deserialize the contents of the request_uri {}", (Object)uri.toString(), (Object)e);
                return null;
            }
            catch (IOException e) {
                this.log.error("Exception catched from the storage service", (Throwable)e);
                return null;
            }
        }
        this.log.error("Request URI content set is null");
        return null;
    }
}

