/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenIntrospectionRequest;
import com.nimbusds.oauth2.sdk.TokenRevocationRequest;
import com.nimbusds.oauth2.sdk.dpop.DPoPUtils;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.DPoPAccessToken;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class DPoPAccessTokenHashFromRequestLookupFunction
extends AbstractIdentifiableInitializableComponent
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DPoPAccessTokenHashFromRequestLookupFunction.class);
    @NonnullAfterInit
    private Supplier<HttpServletRequest> httpServletRequestSupplier;

    public void setHttpServletRequestSupplier(@Nonnull Supplier<HttpServletRequest> supplier) {
        this.httpServletRequestSupplier = (Supplier)Constraint.isNotNull(supplier, (String)"Http servlet request supplier cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpServletRequestSupplier == null) {
            throw new ComponentInitializationException("Http servlet request supplier cannot be null");
        }
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        Enumeration authorizationHeaders;
        ProfileRequestContext profileRequestContext;
        this.checkComponentActive();
        HttpServletRequest httpServletRequest = this.httpServletRequestSupplier.get();
        if (httpServletRequest == null) {
            return null;
        }
        ProfileRequestContext profileRequestContext2 = profileRequestContext = input != null ? input : (ProfileRequestContext)httpServletRequest.getAttribute("opensamlProfileRequestContext");
        if (profileRequestContext != null && profileRequestContext.getInboundMessageContext() != null) {
            Object message = profileRequestContext.ensureInboundMessageContext().getMessage();
            if (message instanceof TokenRevocationRequest) {
                TokenRevocationRequest revocationRequest = (TokenRevocationRequest)message;
                return this.calculateHash(new DPoPAccessToken(revocationRequest.getToken().getValue()));
            }
            if (message instanceof TokenIntrospectionRequest) {
                TokenIntrospectionRequest introspectionRequest = (TokenIntrospectionRequest)message;
                return this.calculateHash(new DPoPAccessToken(introspectionRequest.getToken().getValue()));
            }
        }
        if ((authorizationHeaders = httpServletRequest.getHeaders("Authorization")) == null) {
            return null;
        }
        while (authorizationHeaders.hasMoreElements()) {
            try {
                String hash = this.calculateHash(DPoPAccessToken.parse((String)((String)authorizationHeaders.nextElement())));
                if (hash == null) continue;
                return hash;
            }
            catch (ParseException e) {
                this.log.trace("Could not parse DPoP access token {}", (Object)e.getMessage());
            }
        }
        return null;
    }

    protected String calculateHash(DPoPAccessToken token) {
        try {
            Base64URL hash;
            if (token != null && (hash = DPoPUtils.computeSHA256((AccessToken)token)) != null) {
                return hash.toString();
            }
        }
        catch (JOSEException e) {
            this.log.warn("Could not compute SHA256 hash for the DPoP access token", (Throwable)e);
        }
        return null;
    }
}

