/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSetRequest;
import java.text.ParseException;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationResponseAction;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class SetRequestedSubjectToResponseContext
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetRequestedSubjectToResponseContext.class);
    @Nullable
    private Collection<ClaimsSetRequest.Entry> idTokenClaims;
    @Nullable
    private JWT idTokenHint;

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCClaimsRequest claimsRequest;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        if (oidcResponseContext.getRequestedClaims() != null && (claimsRequest = oidcResponseContext.getRequestedClaims()) != null && claimsRequest.getIDTokenClaimsRequest() != null) {
            this.idTokenClaims = claimsRequest.getIDTokenClaimsRequest().getEntries();
        }
        this.idTokenHint = this.getAuthenticationRequest().getIDTokenHint();
        if (this.idTokenClaims == null && this.idTokenHint == null) {
            this.log.debug("{} No requested claims nor id token hint, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        if (this.idTokenClaims != null) {
            for (ClaimsSetRequest.Entry entry : this.idTokenClaims) {
                if (!"sub".equals(entry.getClaimName())) continue;
                this.log.debug("{} Setting requested sub claim value {}", (Object)this.getLogPrefix(), (Object)entry.getValueAsString());
                oidcResponseContext.setRequestedSubject(entry.getValueAsString());
                return;
            }
        }
        try {
            JWTClaimsSet claimsSet;
            if (this.idTokenHint != null && (claimsSet = this.idTokenHint.getJWTClaimsSet()) != null) {
                this.log.debug("{} Setting requested sub claim value {}", (Object)this.getLogPrefix(), (Object)claimsSet.getSubject());
                oidcResponseContext.setRequestedSubject(claimsSet.getSubject());
            }
        }
        catch (ParseException e) {
            this.log.error("{} error parsing id token hint", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
    }
}

