/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSetRequest;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.AttributesMapContainer;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class SetRequestedClaimsToResponseContext
extends AbstractOIDCResponseAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SetRequestedClaimsToResponseContext.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, OIDCClaimsRequest> requestedClaimsLookupStrategy;
    @NonnullAfterInit
    private ReloadableService<AttributeTranscoderRegistry> transcoderRegistry;

    public void setTranscoderRegistry(@Nonnull ReloadableService<AttributeTranscoderRegistry> registry) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.transcoderRegistry = (ReloadableService)Constraint.isNotNull(registry, (String)"AttributeTranscoderRegistry cannot be null");
    }

    public void setRequestedClaimsLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCClaimsRequest> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.requestedClaimsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RequestedClaimsLookupStrategy lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.transcoderRegistry == null) {
            throw new ComponentInitializationException("AttributeTranscoderRegistry cannot be null");
        }
        if (this.requestedClaimsLookupStrategy == null) {
            throw new ComponentInitializationException("RequestedClaimsLookupStrategy lookup strategy cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        OIDCClaimsRequest cr = this.requestedClaimsLookupStrategy.apply(profileRequestContext);
        oidcResponseContext.setRequestedClaims(cr);
        if (cr == null) {
            oidcResponseContext.setMappedIdTokenRequestedClaims(null);
            oidcResponseContext.setMappedUserinfoRequestedClaims(null);
            return;
        }
        try (ServiceableComponent component = this.transcoderRegistry.getServiceableComponent();){
            Collection transcodingRules;
            JSONObject wrapper;
            HashMultimap results = HashMultimap.create();
            assert (results != null);
            if (cr.getIDTokenClaimsRequest() != null) {
                for (ClaimsSetRequest.Entry entry : cr.getIDTokenClaimsRequest().getEntries()) {
                    wrapper = new JSONObject();
                    wrapper.put((Object)entry.getClaimName(), (Object)entry);
                    transcodingRules = ((AttributeTranscoderRegistry)component.getComponent()).getTranscodingRules((Object)wrapper);
                    this.decodeAttribute(profileRequestContext, transcodingRules, wrapper, (Multimap<String, IdPAttribute>)results);
                }
            }
            oidcResponseContext.setMappedIdTokenRequestedClaims(results.isEmpty() ? null : new AttributesMapContainer((Multimap)results));
            results = HashMultimap.create();
            assert (results != null);
            if (cr.getUserInfoClaimsRequest() != null) {
                for (ClaimsSetRequest.Entry entry : cr.getUserInfoClaimsRequest().getEntries()) {
                    wrapper = new JSONObject();
                    wrapper.put((Object)entry.getClaimName(), (Object)entry);
                    transcodingRules = ((AttributeTranscoderRegistry)component.getComponent()).getTranscodingRules((Object)wrapper);
                    this.decodeAttribute(profileRequestContext, transcodingRules, wrapper, (Multimap<String, IdPAttribute>)results);
                }
            }
            oidcResponseContext.setMappedUserinfoRequestedClaims(results.isEmpty() ? null : new AttributesMapContainer((Multimap)results));
        }
        catch (ServiceException e) {
            this.log.error("Attribute transoding service unavailable");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
        }
    }

    private void decodeAttribute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull @NonnullElements Collection<TranscodingRule> rules, @Nonnull JSONObject input, @Nonnull @NonnullElements @Live Multimap<String, IdPAttribute> results) {
        for (TranscodingRule rule : rules) {
            assert (rule != null);
            AttributeTranscoder transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rule);
            try {
                IdPAttribute decodedAttribute = transcoder.decode(profileRequestContext, (Object)input, rule);
                if (decodedAttribute == null) continue;
                results.put((Object)decodedAttribute.getId(), (Object)decodedAttribute);
            }
            catch (AttributeDecodingException e) {
                this.log.warn("{} Failed to decode requested claim '{}'", (Object)this.getLogPrefix(), input.keySet().iterator().next());
            }
        }
    }
}

