/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.security.Principal;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.PreferredPrincipalContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.impl.DefaultPrincipalDeterminationStrategy;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationResponseAction;
import net.shibboleth.oidc.authn.principal.AuthenticationContextClassReferencePrincipal;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class SetAuthenticationContextClassReferenceToResponseContext
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetAuthenticationContextClassReferenceToResponseContext.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, AuthenticationContextClassReferencePrincipal> classRefLookupStrategy;

    public void setClassRefLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthenticationContextClassReferencePrincipal> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.classRefLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Authentication context class reference strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.classRefLookupStrategy == null) {
            this.classRefLookupStrategy = new DefaultPrincipalDeterminationStrategy(AuthenticationContextClassReferencePrincipal.class, (Principal)new AuthenticationContextClassReferencePrincipal("net.shibboleth.idp.oidc.authn.principal.string.unspecified"));
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (profileRequestContext.getSubcontext(AuthenticationContext.class) == null) {
            this.log.error("{} No authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AuthenticationResult authenticationResult;
        Principal matchingPrincipal;
        String name = null;
        RequestedPrincipalContext requestedPrincipalContext = (RequestedPrincipalContext)((AuthenticationContext)profileRequestContext.ensureSubcontext(AuthenticationContext.class)).getSubcontext(RequestedPrincipalContext.class);
        PreferredPrincipalContext preferredPrincipalContext = (PreferredPrincipalContext)((AuthenticationContext)profileRequestContext.ensureSubcontext(AuthenticationContext.class)).getSubcontext(PreferredPrincipalContext.class);
        Principal principal = matchingPrincipal = requestedPrincipalContext != null ? requestedPrincipalContext.getMatchingPrincipal() : null;
        if (matchingPrincipal != null && matchingPrincipal instanceof AuthenticationContextClassReferencePrincipal) {
            name = matchingPrincipal.getName();
            this.log.debug("{} Setting acr based on requested ctx", (Object)this.getLogPrefix());
        } else if (preferredPrincipalContext != null && (authenticationResult = ((AuthenticationContext)profileRequestContext.ensureSubcontext(AuthenticationContext.class)).getAuthenticationResult()) != null) {
            for (Principal acr : preferredPrincipalContext.getPreferredPrincipals()) {
                if (!authenticationResult.getSupportedPrincipals(AuthenticationContextClassReferencePrincipal.class).contains(acr)) continue;
                name = acr.getName();
                this.log.debug("{} Setting acr based on preferred ctx", (Object)this.getLogPrefix());
                break;
            }
        }
        if (name == null) {
            name = this.classRefLookupStrategy.apply(profileRequestContext).getName();
            this.log.debug("{} Setting acr based on performed flow", (Object)this.getLogPrefix());
        }
        if (!name.equals("net.shibboleth.idp.oidc.authn.principal.string.unspecified")) {
            OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
            assert (oidcResponseContext != null);
            oidcResponseContext.setAcr(name);
            this.log.debug("{} Setting acr to {}", (Object)this.getLogPrefix(), (Object)name);
        }
    }
}

