/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.consent.context.ConsentManagementContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class RevokeConsent
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(RevokeConsent.class);
    @NonnullAfterInit
    private Predicate<ProfileRequestContext> revokePredicate;

    public void setRevokeConsentPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.checkSetterPreconditions();
        this.revokePredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.revokePredicate == null) {
            throw new ComponentInitializationException("Revoke consent predicate cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.revokePredicate.test(profileRequestContext)) {
            this.log.debug("{} Pre-existing consent revoked as predicate returned true", (Object)this.getLogPrefix());
            ((ConsentManagementContext)profileRequestContext.ensureSubcontext(ConsentManagementContext.class)).setRevokeConsent(true);
        } else {
            this.log.debug("{} Pre-existing consent revoked as predicate returned false", (Object)this.getLogPrefix());
        }
    }
}

