/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationMetadataPolicyContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultOIDCClientRegistrationTokenMetadataPolicyLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.DefaultMetadataPolicyMergingStrategy;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.profile.config.navigate.RegistrationMetadataPolicyLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class InitializeRegistrationMetadataPolicyContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeRegistrationMetadataPolicyContext.class);
    @Nonnull
    private Function<ProfileRequestContext, Map<String, MetadataPolicy>> profileMetadataPolicyLookupStrategy = new RegistrationMetadataPolicyLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Map<String, MetadataPolicy>> tokenMetadataPolicyLookupStrategy = new DefaultOIDCClientRegistrationTokenMetadataPolicyLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, OIDCClientRegistrationMetadataPolicyContext> registrationPolicyContextCreationStrategy;
    @Nonnull
    private BiFunction<Map<String, MetadataPolicy>, Map<String, MetadataPolicy>, Pair<Map<String, MetadataPolicy>, Boolean>> metadataPolicyMergingStrategy;
    @NonnullAfterInit
    private Predicate<Map<String, MetadataPolicy>> metadataPolicyValidationStrategy;
    private OIDCClientRegistrationMetadataPolicyContext metadataPolicyContext;

    public InitializeRegistrationMetadataPolicyContext() {
        Function rpccs = new ChildContextLookup(OIDCClientRegistrationMetadataPolicyContext.class, true).compose((Function)new InboundMessageContextLookup());
        assert (rpccs != null);
        this.registrationPolicyContextCreationStrategy = rpccs;
        this.metadataPolicyMergingStrategy = new DefaultMetadataPolicyMergingStrategy();
    }

    public void setProfileMetadataPolicyLookupStrategy(@Nonnull Function<ProfileRequestContext, Map<String, MetadataPolicy>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.profileMetadataPolicyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Profile metadata policy lookup strategy cannot be null");
    }

    public void setTokenMetadataPolicyLookupStrategy(@Nonnull Function<ProfileRequestContext, Map<String, MetadataPolicy>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.tokenMetadataPolicyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Token metadata policy lookup strategy cannot be null");
    }

    public void setRegistrationPolicyContextCreationStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientRegistrationMetadataPolicyContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.registrationPolicyContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCClientRegistrationMetadataPolicyContext creation strategy cannot be null");
    }

    public void setMetadataPolicyMergingStrategy(@Nonnull BiFunction<Map<String, MetadataPolicy>, Map<String, MetadataPolicy>, Pair<Map<String, MetadataPolicy>, Boolean>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.metadataPolicyMergingStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"Metadata policy merging strategy cannot be null");
    }

    public void setMetadataPolicyValidationStrategy(@Nonnull Predicate<Map<String, MetadataPolicy>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.metadataPolicyValidationStrategy = (Predicate)Constraint.isNotNull(strategy, (String)"Metadata policy validation strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        if (this.metadataPolicyValidationStrategy == null) {
            throw new ComponentInitializationException("Metadata policy validation strategy cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.metadataPolicyContext = this.registrationPolicyContextCreationStrategy.apply(profileRequestContext);
        if (this.metadataPolicyContext == null) {
            this.log.error("{} Registration metadata policy context could not be created, invalid profile context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Map mergedPolicy;
        Boolean mergingResult;
        Map<String, MetadataPolicy> profileMetadataPolicy = this.profileMetadataPolicyLookupStrategy.apply(profileRequestContext);
        if (profileMetadataPolicy == null) {
            this.log.warn("{} Metadata policy in profile is not set", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        Map<String, MetadataPolicy> tokenMetadataPolicy = this.tokenMetadataPolicyLookupStrategy.apply(profileRequestContext);
        if (!this.metadataPolicyValidationStrategy.test(tokenMetadataPolicy)) {
            this.log.warn("{} Metadata policy in token is invalid", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        Pair<Map<String, MetadataPolicy>, Boolean> mergedResult = this.metadataPolicyMergingStrategy.apply(profileMetadataPolicy, tokenMetadataPolicy);
        Boolean bl = mergingResult = mergedResult != null ? (Boolean)mergedResult.getSecond() : null;
        if (mergingResult == null || !mergingResult.booleanValue()) {
            this.log.warn("{} Metadata policies from profile and token could not be merged", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        Map map = mergedPolicy = mergedResult != null ? (Map)mergedResult.getFirst() : null;
        if (!this.metadataPolicyValidationStrategy.test(mergedPolicy)) {
            this.log.warn("{} Merged metadata policy is invalid", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        this.metadataPolicyContext.setMetadataPolicy(mergedPolicy);
    }
}

