/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCTokenResponseAction;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class FormOutboundTokenResponseMessage
extends AbstractOIDCTokenResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(FormOutboundTokenResponseMessage.class);
    @Nullable
    private AccessToken accessToken;
    @Nullable
    private JWT idToken;

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        this.accessToken = oidcResponseContext.getAccessToken();
        if (this.accessToken == null) {
            this.log.error("{} unable to provide required access token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.idToken = oidcResponseContext.getProcessedToken();
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        Object resp = this.idToken != null ? new OIDCTokenResponse(new OIDCTokens(this.idToken, this.accessToken, oidcResponseContext.getRefreshToken())) : new AccessTokenResponse(new Tokens(this.accessToken, oidcResponseContext.getRefreshToken()));
        profileRequestContext.ensureOutboundMessageContext().setMessage(resp);
    }
}

