/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformationResponse;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientRegistrationAction;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class FormOutboundClientInformationResponseMessage
extends AbstractOIDCClientRegistrationAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(FormOutboundClientInformationResponseMessage.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCClientInformation clientInformation = this.getRegistrationContext().getClientInformation();
        if (clientInformation == null) {
            this.log.error("{} Could not find client information from context data", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        OIDCClientInformationResponse response = new OIDCClientInformationResponse(clientInformation, true);
        profileRequestContext.ensureOutboundMessageContext().setMessage((Object)response);
        this.log.info("{} Client information successfully added to the outbound context", (Object)this.getLogPrefix());
    }
}

