/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationResponseContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;

public abstract class AbstractOIDCClientRegistrationAction
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractOIDCClientRegistrationAction.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCClientRegistrationResponseContext> oidcResponseContextLookupStrategy;
    @NonnullBeforeExec
    private OIDCClientRegistrationResponseContext oidcResponseContext;

    public AbstractOIDCClientRegistrationAction() {
        Function ocrrls = new ChildContextLookup(OIDCClientRegistrationResponseContext.class).compose((Function)new OutboundMessageContextLookup());
        assert (ocrrls != null);
        this.oidcResponseContextLookupStrategy = ocrrls;
    }

    public void setOidcResponseContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientRegistrationResponseContext> strategy) {
        this.checkSetterPreconditions();
        this.oidcResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"The output OIDCClientRegistrationResponseContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.oidcResponseContext = this.oidcResponseContextLookupStrategy.apply(profileRequestContext);
        if (this.oidcResponseContext == null) {
            this.log.debug("{} No OIDCClientRegistrationResponseContext associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    @Nonnull
    protected OIDCClientRegistrationResponseContext getRegistrationContext() {
        this.checkComponentActive();
        return this.oidcResponseContext;
    }
}

