/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseTokenClaimsContext;
import net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl.AbstractOAuthAuthorizationResponseAction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.ClientInfoScopeLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultOIDCMetadataContextLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.OIDCAuthenticationResponseContextLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.oidc.profile.config.logic.StrictScopeValidationPredicate;
import net.shibboleth.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateScope
extends AbstractOAuthAuthorizationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateScope.class);
    @Nonnull
    private Function<ProfileRequestContext, String> relyingPartyIdLookupStrategy = new RelyingPartyIdLookupFunction();
    @Nullable
    private Function<ProfileRequestContext, Scope> requestedScopeLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Scope> allowedScopeLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Scope> mandatoryScopeLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, ResponseType> requestedResponseTypeLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> strictScopeValidationCondition;
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationResponseTokenClaimsContext> tokenClaimsContextLookupStrategy;

    public ValidateScope() {
        Function asls = new ClientInfoScopeLookupFunction().compose((Function)new DefaultOIDCMetadataContextLookupFunction());
        assert (asls != null);
        this.allowedScopeLookupStrategy = asls;
        this.mandatoryScopeLookupStrategy = prc -> null;
        Function tccls = new ChildContextLookup(OIDCAuthenticationResponseTokenClaimsContext.class).compose((Function)new OIDCAuthenticationResponseContextLookupFunction());
        assert (tccls != null);
        this.tokenClaimsContextLookupStrategy = tccls;
        this.strictScopeValidationCondition = new StrictScopeValidationPredicate();
    }

    public void setRelyingPartyIdLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.relyingPartyIdLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Relying party ID lookup strategy cannot be null");
    }

    public void setRequestedScopeLookupStrategy(@Nullable Function<ProfileRequestContext, Scope> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.requestedScopeLookupStrategy = strategy;
    }

    public void setAllowedScopeLookupStrategy(@Nonnull Function<ProfileRequestContext, Scope> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.allowedScopeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Allowed scope lookup strategy cannot be null");
    }

    public void setMandatoryScopeLookupStrategy(@Nonnull Function<ProfileRequestContext, Scope> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.mandatoryScopeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Mandatory scope lookup strategy cannot be null");
    }

    public void setOIDCAuthenticationResponseTokenClaimsContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationResponseTokenClaimsContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.tokenClaimsContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCAuthenticationResponseTokenClaimsContextt lookup strategy cannot be null");
    }

    public void setRequestedResponseTypeLookupStrategy(@Nullable Function<ProfileRequestContext, ResponseType> strategy) {
        this.checkSetterPreconditions();
        this.requestedResponseTypeLookupStrategy = strategy;
    }

    public void setStrictScopeValidationCondition(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.checkSetterPreconditions();
        this.strictScopeValidationCondition = (Predicate)Constraint.isNotNull(predicate, (String)"StrictScopeValidationCondition cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        BaseContext parentContext;
        OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx;
        ResponseType responseType;
        boolean strictValidation;
        Scope requestedScopes;
        String clientId = this.relyingPartyIdLookupStrategy.apply(profileRequestContext);
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        Scope previouslyGrantedScopes = null;
        TokenClaimsSet authzGrantClaimsSet = oidcResponseContext.getAuthorizationGrantClaimsSet();
        if (authzGrantClaimsSet != null) {
            previouslyGrantedScopes = authzGrantClaimsSet.getScope();
        }
        Scope scope = requestedScopes = this.requestedScopeLookupStrategy != null ? this.requestedScopeLookupStrategy.apply(profileRequestContext) : null;
        if (requestedScopes == null) {
            requestedScopes = previouslyGrantedScopes;
            previouslyGrantedScopes = null;
        }
        Scope allowedScopes = this.allowedScopeLookupStrategy.apply(profileRequestContext);
        String oidcScope = OIDCScopeValue.OPENID.getValue();
        if (requestedScopes != null && requestedScopes.contains(oidcScope) && (allowedScopes == null || !allowedScopes.contains(oidcScope))) {
            this.log.warn("{} OIDC sequence was requested but no openid scope granted for RP {}", (Object)this.getLogPrefix(), (Object)clientId);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidScope");
            return;
        }
        Scope mandatoryScopes = this.mandatoryScopeLookupStrategy.apply(profileRequestContext);
        if (mandatoryScopes != null && !mandatoryScopes.isEmpty()) {
            if (requestedScopes == null || requestedScopes.isEmpty()) {
                this.log.warn("{} Mendatory scope set to {} but none requested", (Object)this.getLogPrefix(), (Object)mandatoryScopes.toString());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidScope");
                return;
            }
            for (Scope.Value value : mandatoryScopes) {
                if (requestedScopes.contains(value.getValue())) continue;
                this.log.warn("{} Mandatory scope {} is not requested", (Object)this.getLogPrefix(), (Object)value.getValue());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidScope");
                return;
            }
        }
        if ((strictValidation = this.strictScopeValidationCondition.test(profileRequestContext)) && requestedScopes != null && !requestedScopes.isEmpty() && (allowedScopes == null || allowedScopes.isEmpty())) {
            this.log.warn("{} Strict scope validation is active and no allowed scopes for RP {}", (Object)this.getLogPrefix(), (Object)clientId);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidScope");
            return;
        }
        if (allowedScopes == null || allowedScopes.isEmpty()) {
            this.log.debug("{} No allowed scope for client {}, nothing to do", (Object)this.getLogPrefix(), (Object)clientId);
            return;
        }
        if (requestedScopes == null || requestedScopes.isEmpty()) {
            this.log.debug("{} No requested scope for client {}, nothing to do", (Object)this.getLogPrefix(), (Object)clientId);
            return;
        }
        boolean reducedRequestedScopes = false;
        Iterator i = requestedScopes.iterator();
        while (i.hasNext()) {
            Scope.Value scope2 = (Scope.Value)i.next();
            if (!allowedScopes.contains((Object)scope2)) {
                if (strictValidation) {
                    this.log.warn("{} Requested unregistered scope {} for RP {} with strict validation", new Object[]{this.getLogPrefix(), scope2.getValue(), clientId});
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidScope");
                    return;
                }
                this.log.warn("{} Removing requested but unregistered scope {} for RP {}", new Object[]{this.getLogPrefix(), scope2.getValue(), clientId});
                i.remove();
                continue;
            }
            if (previouslyGrantedScopes == null || previouslyGrantedScopes.contains((Object)scope2)) continue;
            if (strictValidation) {
                this.log.warn("{} Requested previously ungranted scope {} for RP {}", new Object[]{this.getLogPrefix(), scope2.getValue(), clientId});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidScope");
                return;
            }
            this.log.warn("{} Removing requested but previously ungranted scope {} for RP {}", new Object[]{this.getLogPrefix(), scope2.getValue(), clientId});
            i.remove();
            reducedRequestedScopes = true;
        }
        if (requestedScopes.contains((Object)OIDCScopeValue.OFFLINE_ACCESS) && this.requestedResponseTypeLookupStrategy != null && (responseType = this.requestedResponseTypeLookupStrategy.apply(profileRequestContext)) != null && !responseType.contains((Object)ResponseType.Value.CODE)) {
            requestedScopes.remove((Object)OIDCScopeValue.OFFLINE_ACCESS);
        }
        if (!requestedScopes.isEmpty()) {
            oidcResponseContext.setScope(requestedScopes);
        }
        if (reducedRequestedScopes && (tokenClaimsCtx = this.tokenClaimsContextLookupStrategy.apply(profileRequestContext)) != null && (parentContext = tokenClaimsCtx.getParent()) != null) {
            this.log.debug("{} Removing grant-encoded attributes due to reduction of requested scopes", (Object)this.getLogPrefix());
            parentContext.removeSubcontext((BaseContext)tokenClaimsCtx);
        }
    }
}

