/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl.AbstractOAuthAuthorizationRequestAction;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.DefaultAuthorizationRequestTypeValidationStrategy;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateAuthorizationRequestType
extends AbstractOAuthAuthorizationRequestAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateAuthorizationRequestType.class);
    @Nonnull
    private Predicate<ProfileRequestContext> authorizationRequestTypeValidationStrategy = new DefaultAuthorizationRequestTypeValidationStrategy();

    public void setAuthorizationRequestTypeValidationStrategy(@Nonnull Predicate<ProfileRequestContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.authorizationRequestTypeValidationStrategy = (Predicate)Constraint.isNotNull(strategy, (String)"Authorization request type validation strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!this.authorizationRequestTypeValidationStrategy.test(profileRequestContext)) {
            this.log.warn("{} The request did not match with the configured authorization request type requirements", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
    }
}

