/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate.TokenRequestAudienceLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.ClientInfoAudienceLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultOIDCMetadataContextLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationResponseAction;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.DefaultEnforceSelfAudienceCondition;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.IssueIDTokenCondition;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.ProxiedRequesterContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;

public class ValidateAudience
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateAudience.class);
    @Nonnull
    private Function<ProfileRequestContext, String> relyingPartyIdLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, List<String>> requestedAudienceLookupStrategy = new TokenRequestAudienceLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, List<String>> allowedAudienceLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, ProxiedRequesterContext> proxiedRequesterContextCreationStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> selfAudienceCondition;
    @Nonnull
    private Predicate<ProfileRequestContext> enforceSelfAudienceCondition;

    public ValidateAudience() {
        this.relyingPartyIdLookupStrategy = new IssuerLookupFunction();
        Function aals = new ClientInfoAudienceLookupFunction().compose((Function)new DefaultOIDCMetadataContextLookupFunction());
        assert (aals != null);
        this.allowedAudienceLookupStrategy = aals;
        Function prccs = new ChildContextLookup(ProxiedRequesterContext.class, true).compose((Function)new OutboundMessageContextLookup());
        assert (prccs != null);
        this.proxiedRequesterContextCreationStrategy = prccs;
        this.selfAudienceCondition = new IssueIDTokenCondition();
        this.enforceSelfAudienceCondition = new DefaultEnforceSelfAudienceCondition();
    }

    public void setRelyingPartyIdLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.relyingPartyIdLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Relying party ID lookup strategy cannot be null");
    }

    public void setRequestedAudienceLookupStrategy(@Nullable Function<ProfileRequestContext, List<String>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.requestedAudienceLookupStrategy = strategy;
    }

    public void setAllowedAudienceLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.allowedAudienceLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Allowed scope lookup strategy cannot be null");
    }

    public void setProxiedRequesterContextCreationStrategy(@Nonnull Function<ProfileRequestContext, ProxiedRequesterContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.proxiedRequesterContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProxiedRequesterContext lookup strategy cannot be null");
    }

    public void setSelfAudienceCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.selfAudienceCondition = (Predicate)Constraint.isNotNull(condition, (String)"Self audience condition cannot be null");
    }

    public void setEnforceSelfAudienceCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.enforceSelfAudienceCondition = (Predicate)Constraint.isNotNull(condition, (String)"Enforce self audience condition cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        List<String> requestedAudience;
        String clientId = this.relyingPartyIdLookupStrategy.apply(profileRequestContext);
        boolean allowNone = this.selfAudienceCondition.test(profileRequestContext);
        List<String> allowedAudience = this.allowedAudienceLookupStrategy.apply(profileRequestContext);
        List<String> previouslyGrantedAudience = null;
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        TokenClaimsSet grantClaimsSet = oidcResponseContext.getAuthorizationGrantClaimsSet();
        if (grantClaimsSet != null) {
            previouslyGrantedAudience = grantClaimsSet.getAudience();
        }
        List<String> list = requestedAudience = this.requestedAudienceLookupStrategy != null ? this.requestedAudienceLookupStrategy.apply(profileRequestContext) : null;
        if (allowedAudience == null || allowedAudience.isEmpty()) {
            if (allowNone) {
                if (previouslyGrantedAudience != null && !previouslyGrantedAudience.isEmpty() || requestedAudience != null && !requestedAudience.isEmpty()) {
                    this.log.warn("{} No allowed audiences for client {}, OP will be sole audience", (Object)this.getLogPrefix(), (Object)clientId);
                } else {
                    this.log.debug("{} No allowed audiences for client {}, OP will be sole audience", (Object)this.getLogPrefix(), (Object)clientId);
                }
            } else {
                this.log.warn("{} No allowed audience for client {}", (Object)this.getLogPrefix(), (Object)clientId);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidTarget");
            }
            return;
        }
        boolean enforceSelfAudience = this.enforceSelfAudienceCondition.test(profileRequestContext);
        if (enforceSelfAudience) {
            if (allowNone) {
                this.log.debug("{} Self-audience enforced for {}, OP will be sole audience", (Object)this.getLogPrefix(), (Object)clientId);
                return;
            }
            this.log.warn("{} Ignoring the self-audience enforcing for {}, as self-audience is not allowed", (Object)this.getLogPrefix(), (Object)clientId);
        }
        if (requestedAudience == null) {
            requestedAudience = previouslyGrantedAudience;
            previouslyGrantedAudience = null;
        }
        if (requestedAudience == null || requestedAudience.isEmpty()) {
            if (allowNone) {
                this.log.debug("{} No audience in request for client {}, OP will be sole audience", (Object)this.getLogPrefix(), (Object)clientId);
                return;
            }
            this.log.debug("{} No audience in request for client {}, using first allowed", (Object)this.getLogPrefix(), (Object)clientId);
            requestedAudience = Collections.singletonList(allowedAudience.get(0));
        }
        ArrayList<String> effectiveAudience = new ArrayList<String>();
        for (String aud : requestedAudience) {
            if (!allowedAudience.contains(aud)) {
                this.log.warn("{} Omitting requested but unregistered audience {} for RP {}", new Object[]{this.getLogPrefix(), aud, clientId});
                continue;
            }
            if (previouslyGrantedAudience != null && !previouslyGrantedAudience.contains(aud)) {
                this.log.warn("{} Omitting requested but previously ungranted audience {} for RP {}", new Object[]{this.getLogPrefix(), aud, clientId});
                continue;
            }
            effectiveAudience.add(aud);
        }
        if (effectiveAudience.isEmpty()) {
            if (allowNone) {
                this.log.debug("{} No allowed audience for client {}, OP will be sole audience", (Object)this.getLogPrefix(), (Object)clientId);
            } else {
                this.log.warn("{} No allowed audience for client {}", (Object)this.getLogPrefix(), (Object)clientId);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidTarget");
            }
            return;
        }
        this.log.debug("{} Computed audience for client {}: {}", new Object[]{this.getLogPrefix(), clientId, effectiveAudience});
        oidcResponseContext.getAudience().addAll(effectiveAudience);
        ProxiedRequesterContext proxyCtx = this.proxiedRequesterContextCreationStrategy.apply(profileRequestContext);
        if (proxyCtx == null) {
            this.log.error("{} Unable to locate/create ProxiedRequesterContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        proxyCtx.getRequesters().addAll(effectiveAudience);
    }
}

