/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.PushedAuthorizationRequest;
import com.nimbusds.oauth2.sdk.PushedAuthorizationSuccessResponse;
import java.net.URI;
import java.text.ParseException;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl.AbstractOAuthAuthorizationResponseAction;
import net.shibboleth.idp.plugin.oidc.op.profile.RequestUriClaimsSetDecorator;
import net.shibboleth.oidc.profile.config.navigate.PushedAuthorizationRequestUriClaimsSetManipulationStrategyLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.PushedAuthorizationRequestUriLifetimeLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.PushedAuthorizationRequestUriTypeLookupFunction;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class FormOutbounPushedAuthorizationResponseMessage
extends AbstractOAuthAuthorizationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(FormOutbounPushedAuthorizationResponseMessage.class);
    @Nonnull
    private Function<ProfileRequestContext, String> requestUriTypeLookupStrategy = new PushedAuthorizationRequestUriTypeLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Duration> requestUriLifetimeLookupStrategy = new PushedAuthorizationRequestUriLifetimeLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> requestUriClaimsSetManipulationStrategyLookupStrategy = new PushedAuthorizationRequestUriClaimsSetManipulationStrategyLookupFunction();
    @Nonnull
    private Map<String, BiFunction<ProfileRequestContext, Map<String, Object>, URI>> requestUriClaimsSetSerializationStrategies = CollectionSupport.emptyMap();
    @Nonnull
    private Collection<RequestUriClaimsSetDecorator> requestUriClaimsSetDecorators;
    @Nullable
    private String requestUriType;
    @Nullable
    private Duration requestUriLifetime;
    @Nullable
    private BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> manipulationStrategy;
    @Nullable
    private PushedAuthorizationRequest requestMessage;

    @Autowired
    public FormOutbounPushedAuthorizationResponseMessage(@Nullable Collection<RequestUriClaimsSetDecorator> decorators) {
        this.requestUriClaimsSetDecorators = decorators != null ? CollectionSupport.copyToList(decorators) : CollectionSupport.emptyList();
    }

    public void setRequestUriClaimsSetSerializationStrategies(@Nonnull Map<String, BiFunction<ProfileRequestContext, Map<String, Object>, URI>> strategies) {
        super.checkSetterPreconditions();
        this.requestUriClaimsSetSerializationStrategies = (Map)Constraint.isNotNull(strategies, (String)"Request URI serialization strategies cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        Object request = this.getRequest();
        if (!(request instanceof PushedAuthorizationRequest)) {
            this.log.error("{} The request message type is unexpected {}", (Object)this.getLogPrefix(), request);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.requestMessage = (PushedAuthorizationRequest)request;
        this.requestUriType = StringSupport.trimOrNull((String)this.requestUriTypeLookupStrategy.apply(profileRequestContext));
        this.requestUriLifetime = this.requestUriLifetimeLookupStrategy.apply(profileRequestContext);
        if (this.requestUriLifetime == null) {
            this.log.warn("{} No lifetime supplied for request URI", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        this.manipulationStrategy = this.requestUriClaimsSetManipulationStrategyLookupStrategy.apply(profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Map<String, Object> claimsSet;
        try {
            claimsSet = this.buildClaimsSet(profileRequestContext);
        }
        catch (ParseException e) {
            this.log.error("{} Could not parse the claims set from the request object", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        BiFunction<ProfileRequestContext, Map<String, Object>, URI> serializationStrategy = this.requestUriClaimsSetSerializationStrategies.get(this.requestUriType == null ? "" : this.requestUriType);
        if (serializationStrategy == null) {
            this.log.error("{} Could not find a serialization strategy for request URI type {}", (Object)this.getLogPrefix(), (Object)this.requestUriType);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return;
        }
        URI serializedUri = serializationStrategy.apply(profileRequestContext, claimsSet);
        if (serializedUri == null) {
            this.log.error("{} Could not serialize the claims set with request URI type {}", (Object)this.getLogPrefix(), (Object)this.requestUriType);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return;
        }
        if (serializedUri.toASCIIString().length() > 512) {
            this.log.warn("{} The serialized URI value length exceeds 512 ASCII characters", (Object)this.getLogPrefix());
        }
        assert (this.requestUriLifetime != null);
        long lifetime = this.requestUriLifetime.getSeconds();
        PushedAuthorizationSuccessResponse response = new PushedAuthorizationSuccessResponse(serializedUri, lifetime);
        profileRequestContext.ensureOutboundMessageContext().setMessage((Object)response);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nonnull
    protected Map<String, Object> buildClaimsSet(@Nonnull ProfileRequestContext profileRequestContext) throws ParseException {
        HashMap<String, Object> claimsSet;
        OIDCAuthenticationResponseContext oidcContext = this.getOidcResponseContext();
        assert (oidcContext != null);
        JWT requestObject = oidcContext.getRequestObject();
        if (requestObject == null) {
            assert (this.requestMessage != null);
            claimsSet = new HashMap(this.requestMessage.getAuthorizationRequest().toJWTClaimsSet().getClaims());
        } else {
            claimsSet = new HashMap<String, Object>(requestObject.getJWTClaimsSet().getClaims());
        }
        for (RequestUriClaimsSetDecorator decorator : this.requestUriClaimsSetDecorators) {
            decorator.accept(claimsSet, (Object)profileRequestContext);
        }
        if (this.manipulationStrategy != null) {
            this.log.debug("{} Manipulation strategy has been set, applying it to the claims set {}", (Object)this.getLogPrefix(), claimsSet);
            assert (this.manipulationStrategy != null);
            Map<String, Object> result = this.manipulationStrategy.apply(profileRequestContext, claimsSet);
            if (result != null) {
                this.log.debug("{} Manipulation strategy changed the contents of the claims set", (Object)this.getLogPrefix());
                return result;
            }
            this.log.debug("{} Manipulation strategy returned null, leaving claims set untouched.", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} No manipulation strategy configured", (Object)this.getLogPrefix());
        }
        assert (claimsSet != null);
        return claimsSet;
    }
}

