/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl;

import com.google.common.base.MoreObjects;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.PushedAuthorizationRequest;
import com.nimbusds.oauth2.sdk.Request;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.JakartaServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.decoding.impl.RequestUtil;
import net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl.BaseOAuth2RequestDecoder;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.slf4j.Logger;

public class OAuth2PushedAuthorizationRequestDecoder
extends BaseOAuth2RequestDecoder<PushedAuthorizationRequest> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OAuth2PushedAuthorizationRequestDecoder.class);

    @Override
    protected PushedAuthorizationRequest parseMessage() throws MessageDecodingException {
        try {
            HTTPRequest httpReq = JakartaServletUtils.createHTTPRequest((HttpServletRequest)this.getHttpServletRequest());
            this.getProtocolMessageLogger().trace("Inbound request {}", (Object)RequestUtil.toString(httpReq));
            if (httpReq != null) {
                this.switchIntoCustomResource(httpReq);
                return PushedAuthorizationRequest.parse((HTTPRequest)httpReq);
            }
            throw new MessageDecodingException("Could not create HTTPRequest object from the incoming request");
        }
        catch (ParseException | IOException e) {
            this.log.error("Unable to decode inbound request: {}", (Object)e.getMessage());
            throw new MessageDecodingException((Exception)e);
        }
    }

    @Override
    protected String getMessageToLog(@Nullable PushedAuthorizationRequest message) {
        if (message == null) {
            return null;
        }
        AuthorizationRequest request = message.getAuthorizationRequest();
        assert (request != null);
        return MoreObjects.toStringHelper((Object)((Object)this)).omitNullValues().add("clientId", (Object)request.getClientID()).add("codeChallenge", (Object)request.getCodeChallenge()).add("codeChallengeMethod", (Object)request.getCodeChallengeMethod()).add("customParameters", (Object)request.getCustomParameters()).add("endpointURI", (Object)this.getEndpointURI((Request)request)).add("prompt", (Object)request.getPrompt()).add("redirectionURI", (Object)request.getRedirectionURI()).add("requestObject", request.getRequestObject() == null ? null : request.getRequestObject().serialize()).add("requestURI", (Object)request.getRequestURI()).add("resources", (Object)request.getResources()).add("responseMode", (Object)request.getResponseMode()).add("responseType", (Object)request.getResponseType()).add("scope", (Object)request.getScope()).add("state", (Object)request.getState()).toString();
    }
}

