/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.impl;

import com.nimbusds.oauth2.sdk.Response;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public class RpInitiatedLogoutResponse
implements Response {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RpInitiatedLogoutResponse.class);
    @Nullable
    private final String postLogoutRedirectionUri;
    @Nullable
    private final String state;

    public RpInitiatedLogoutResponse(@Nullable String uri) {
        this(uri, null);
    }

    public RpInitiatedLogoutResponse(@Nullable String uri, @Nullable String relayState) {
        this.postLogoutRedirectionUri = uri;
        this.state = StringSupport.trimOrNull((String)relayState);
    }

    public boolean indicatesSuccess() {
        return true;
    }

    public HTTPResponse toHTTPResponse() {
        if (this.postLogoutRedirectionUri == null) {
            return new HTTPResponse(200);
        }
        HTTPResponse response = new HTTPResponse(302);
        try {
            URI uri;
            if (this.state != null) {
                assert (this.postLogoutRedirectionUri != null);
                uri = this.postLogoutRedirectionUri.contains("?") ? new URI(this.serializeParameters(this.postLogoutRedirectionUri + "&")) : new URI(this.serializeParameters(this.postLogoutRedirectionUri + "?"));
            } else {
                uri = new URI(this.postLogoutRedirectionUri);
            }
            response.setLocation(uri);
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            this.log.error("Could not construct an URI object", (Throwable)e);
        }
        return response;
    }

    @Nonnull
    protected String serializeParameters(@Nonnull String prefix) throws UnsupportedEncodingException {
        if (this.state != null) {
            return prefix + "state=" + URLEncoder.encode(this.state, "UTF-8");
        }
        return prefix;
    }
}

