/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.PushedAuthorizationRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.text.ParseException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate.AbstractAuthenticationRequestLookupFunction;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultRequestLoginHintLookupFunction
extends AbstractAuthenticationRequestLookupFunction<String> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestLoginHintLookupFunction.class);

    @Override
    @Nullable
    protected String doLookup(@Nonnull AuthenticationRequest req, @Nullable PushedAuthorizationRequest parRequest, @Nullable JWT requestObject, boolean isRequestObjectFromPar) {
        try {
            if (requestObject != null && requestObject.getJWTClaimsSet().getClaim("login_hint") != null) {
                Object hint = requestObject.getJWTClaimsSet().getClaim("login_hint");
                if (hint instanceof String) {
                    return (String)hint;
                }
                this.log.error("login_hint claim is not of expected type");
                return null;
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse login hint from request object login_hint value");
            return null;
        }
        return this.checkRequestObject((AuthorizationRequest)req, isRequestObjectFromPar, "login_hint", req.getLoginHint(), null);
    }
}

