/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.PushedAuthorizationRequest;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate.DefaultUseOnlyRequestObjectPredicate;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public abstract class AbstractAuthorizationRequestLookupFunction<T>
extends AbstractInitializableComponent
implements ContextDataLookupFunction<ProfileRequestContext, T> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractAuthorizationRequestLookupFunction.class);
    @Nonnull
    private final Class<? extends AuthorizationRequest> messageClass;
    @Nonnull
    private BiPredicate<Pair<AuthorizationRequest, Boolean>, String> useOnlyRequestObjectPredicate;

    public AbstractAuthorizationRequestLookupFunction() {
        this(AuthorizationRequest.class);
    }

    protected AbstractAuthorizationRequestLookupFunction(@Nonnull Class<? extends AuthorizationRequest> clazz) {
        this.messageClass = (Class)Constraint.isNotNull(clazz, (String)"Message class cannot be null");
        this.useOnlyRequestObjectPredicate = new DefaultUseOnlyRequestObjectPredicate();
    }

    public void setUseOnlyRequestObjectPredicate(@Nonnull BiPredicate<Pair<AuthorizationRequest, Boolean>, String> predicate) {
        this.checkSetterPreconditions();
        this.useOnlyRequestObjectPredicate = (BiPredicate)Constraint.isNotNull(predicate, (String)"Use only request object predicate cannot be null");
    }

    @Nullable
    protected abstract T doLookup(@Nonnull AuthorizationRequest var1, @Nullable PushedAuthorizationRequest var2, @Nullable JWT var3, boolean var4);

    @Nullable
    public T apply(@Nullable ProfileRequestContext input) {
        boolean isRequestObjectFromPar;
        JWT localRequestObject;
        this.checkComponentActive();
        if (input == null || input.getInboundMessageContext() == null) {
            return null;
        }
        Object message = input.ensureInboundMessageContext().getMessage();
        if (message == null || !this.messageClass.isInstance(message) && !(message instanceof PushedAuthorizationRequest)) {
            return null;
        }
        if (input.getOutboundMessageContext() != null && input.ensureOutboundMessageContext().containsSubcontext(OIDCAuthenticationResponseContext.class)) {
            OIDCAuthenticationResponseContext ctx = (OIDCAuthenticationResponseContext)input.ensureOutboundMessageContext().ensureSubcontext(OIDCAuthenticationResponseContext.class);
            localRequestObject = ctx.getRequestObject();
            isRequestObjectFromPar = ctx.isRequestObjectFromPar();
        } else {
            localRequestObject = null;
            isRequestObjectFromPar = false;
        }
        if (message instanceof PushedAuthorizationRequest) {
            PushedAuthorizationRequest pushedAuthorizationRequest = (PushedAuthorizationRequest)message;
            AuthorizationRequest authorizationRequest = pushedAuthorizationRequest.getAuthorizationRequest();
            assert (authorizationRequest != null);
            return this.doLookup(authorizationRequest, pushedAuthorizationRequest, localRequestObject, isRequestObjectFromPar);
        }
        return this.doLookup((AuthorizationRequest)message, null, localRequestObject, isRequestObjectFromPar);
    }

    @Nullable
    protected T checkRequestObject(@Nonnull AuthorizationRequest authorizationRequest, boolean isRequestObjectFromPar, @Nonnull String parameterName, @Nullable T parameterValue, @Nullable T defaultResult) {
        if (this.useOnlyRequestObjectPredicate.test((Pair<AuthorizationRequest, Boolean>)new Pair((Object)authorizationRequest, (Object)isRequestObjectFromPar), parameterName)) {
            this.log.debug("Ignoring value {}={} from authorization request as request object is defined", (Object)parameterName, parameterValue);
            return defaultResult;
        }
        return parameterValue;
    }
}

