/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.logout.profile.impl;

import java.net.URI;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.logout.profile.impl.AbstractOIDCRpInitiatedLogoutAction;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCRpInitiatedLogoutContext;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.DefaultPostLogoutRedirectURIValidationPredicate;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidatePostLogoutRedirectURI
extends AbstractOIDCRpInitiatedLogoutAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidatePostLogoutRedirectURI.class);
    @Nonnull
    private BiPredicate<ProfileRequestContext, URI> redirectURIValidationStrategy = new DefaultPostLogoutRedirectURIValidationPredicate();
    @Nullable
    private URI requestedRedirectURI;

    public void setRedirectURIValidationStrategy(@Nonnull BiPredicate<ProfileRequestContext, URI> strategy) {
        this.checkSetterPreconditions();
        this.redirectURIValidationStrategy = (BiPredicate)Constraint.isNotNull(strategy, (String)"RedirectURILookupStrategy lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        OIDCRpInitiatedLogoutContext rpInitiatedLogoutContext = this.getRpInitiatedLogoutContext();
        assert (rpInitiatedLogoutContext != null);
        this.requestedRedirectURI = rpInitiatedLogoutContext.getPostLogoutRedirectUri();
        if (this.requestedRedirectURI == null) {
            this.log.debug("{} No post logout redirect URI found, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!this.redirectURIValidationStrategy.test(profileRequestContext, this.requestedRedirectURI)) {
            this.log.warn("{} Post logout redirection URI {} did not pass the validation", (Object)this.getLogPrefix(), (Object)this.requestedRedirectURI);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURI");
            return;
        }
        this.log.debug("{} Post logout redirection URI {} successfully validated", (Object)this.getLogPrefix(), (Object)this.requestedRedirectURI);
    }
}

