/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.logout.profile.impl;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.net.URI;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.logout.profile.impl.AbstractOIDCLogoutPropagationAction;
import net.shibboleth.idp.plugin.oidc.op.messaging.impl.FrontChannelLogoutPropagationResponse;
import net.shibboleth.idp.plugin.oidc.op.session.OIDCRPSession;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class FormOutboundLogoutRequestMessage
extends AbstractOIDCLogoutPropagationAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(FormOutboundLogoutRequestMessage.class);
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy = new IssuerLookupFunction();
    @Nullable
    private String issuer;
    @Nullable
    private OIDCClientInformation clientInformation;
    @Nullable
    private URI frontChannelLogoutUri;

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IssuerLookupStrategy lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.issuer = this.issuerLookupStrategy.apply(profileRequestContext);
        if (StringSupport.trimOrNull((String)this.issuer) == null) {
            this.log.error("{} Could not resolve value for issuer even though it's required", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        OIDCMetadataContext metadataContext = this.getMetadataContext();
        if (metadataContext == null || metadataContext.getClientInformation() == null) {
            this.log.error("{} Could not find OIDC metadata", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        this.clientInformation = metadataContext.getClientInformation();
        assert (this.clientInformation != null);
        this.frontChannelLogoutUri = this.clientInformation.getOIDCMetadata().getFrontChannelLogoutURI();
        if (this.frontChannelLogoutUri == null) {
            this.log.error("{} No front-channel logout URI registered for the client", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        FrontChannelLogoutPropagationResponse response;
        assert (this.frontChannelLogoutUri != null);
        String uri = this.frontChannelLogoutUri.toString();
        assert (uri != null);
        assert (this.clientInformation != null);
        if (this.clientInformation.getOIDCMetadata().requiresFrontChannelLogoutSession()) {
            OIDCRPSession rpSession = this.getOidcRPSession();
            assert (rpSession != null);
            response = new FrontChannelLogoutPropagationResponse(uri, this.issuer, rpSession.getSessionIdentifier());
        } else {
            response = new FrontChannelLogoutPropagationResponse(uri);
        }
        profileRequestContext.ensureOutboundMessageContext().setMessage((Object)response);
    }
}

