/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.logout.profile.impl;

import com.nimbusds.openid.connect.sdk.LogoutRequest;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCRpInitiatedLogoutContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCRequestAction;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;

public class AbstractOIDCRpInitiatedLogoutAction
extends AbstractOIDCRequestAction<LogoutRequest> {
    @Nonnull
    private static final Logger log = LoggerFactory.getLogger(AbstractOIDCRpInitiatedLogoutAction.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcMetadataCtxLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, OIDCRpInitiatedLogoutContext> oidcRpInitatedLogoutCtxLookupStrategy;
    @Nullable
    private OIDCMetadataContext oidcMetadataContext;
    @Nullable
    private OIDCRpInitiatedLogoutContext rpInitiatedLogoutContext;

    public AbstractOIDCRpInitiatedLogoutAction() {
        Function omcls = new ChildContextLookup(OIDCMetadataContext.class).compose((Function)new InboundMessageContextLookup());
        assert (omcls != null);
        this.oidcMetadataCtxLookupStrategy = omcls;
        Function orilcls = new ChildContextLookup(OIDCRpInitiatedLogoutContext.class).compose((Function)new OutboundMessageContextLookup());
        assert (orilcls != null);
        this.oidcRpInitatedLogoutCtxLookupStrategy = orilcls;
    }

    public void setOIDCRpInitatedLogoutCtxLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCRpInitiatedLogoutContext> strategy) {
        this.checkSetterPreconditions();
        this.oidcRpInitatedLogoutCtxLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setOIDCMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCMetadataContext> strategy) {
        this.checkSetterPreconditions();
        this.oidcMetadataCtxLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.oidcMetadataContext = this.oidcMetadataCtxLookupStrategy.apply(profileRequestContext);
        if (this.oidcMetadataContext == null) {
            log.error("{} No OIDC metadata context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.rpInitiatedLogoutContext = this.oidcRpInitatedLogoutCtxLookupStrategy.apply(profileRequestContext);
        if (this.rpInitiatedLogoutContext == null) {
            log.error("{} No RP-initiated OIDC logout context found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    public OIDCMetadataContext getMetadataContext() {
        return this.oidcMetadataContext;
    }

    @Nullable
    public OIDCRpInitiatedLogoutContext getRpInitiatedLogoutContext() {
        return this.rpInitiatedLogoutContext;
    }

    public LogoutRequest getLogoutRequest() {
        return (LogoutRequest)this.getRequest();
    }
}

