/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.logout.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCLogoutPropagationContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.idp.plugin.oidc.op.session.OIDCRPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.context.LogoutPropagationContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AbstractOIDCLogoutPropagationAction
extends AbstractOIDCResponseAction {
    @Nonnull
    private static final Logger log = LoggerFactory.getLogger(AbstractOIDCLogoutPropagationAction.class);
    @Nonnull
    private Function<ProfileRequestContext, LogoutPropagationContext> logoutPropagationContextLookupStrategy = new ChildContextLookup(LogoutPropagationContext.class);
    @Nullable
    private OIDCLogoutPropagationContext oidcLogoutContext;
    @Nullable
    private LogoutPropagationContext logoutPropagationContext;
    @Nullable
    private OIDCRPSession oidcRPSession;

    public void setLogoutPropagationContextLookupStrategy(@Nonnull Function<ProfileRequestContext, LogoutPropagationContext> strategy) {
        this.checkSetterPreconditions();
        this.logoutPropagationContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"LogoutPropagationContext lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCRPSession rpSession;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.oidcLogoutContext = (OIDCLogoutPropagationContext)profileRequestContext.ensureOutboundMessageContext().getSubcontext(OIDCLogoutPropagationContext.class);
        if (this.oidcLogoutContext == null) {
            log.error("{} No OIDC logout context found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.logoutPropagationContext = this.logoutPropagationContextLookupStrategy.apply(profileRequestContext);
        if (this.logoutPropagationContext == null) {
            log.error("{} No logout propagation context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        assert (this.logoutPropagationContext != null);
        SPSession sPSession = this.logoutPropagationContext.getSession();
        if (!(sPSession instanceof OIDCRPSession)) {
            log.error("{} Logout propagation context did not contain a OIDCRPSession", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.oidcRPSession = rpSession = (OIDCRPSession)sPSession;
        return true;
    }

    @Nullable
    protected OIDCLogoutPropagationContext getOidcLogoutContext() {
        return this.oidcLogoutContext;
    }

    @Nullable
    protected LogoutPropagationContext getLogoutPropagationContext() {
        return this.logoutPropagationContext;
    }

    @Nullable
    protected OIDCRPSession getOidcRPSession() {
        return this.oidcRPSession;
    }
}

