/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.encoding.impl;

import com.nimbusds.oauth2.sdk.Response;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class OIDCResponseEncoderFactory
extends AbstractInitializableComponent
implements Function<ProfileRequestContext, MessageEncoder> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OIDCResponseEncoderFactory.class);
    @NonnullAfterInit
    private MessageEncoder messageEncoder;

    public void setMessageEncoder(@Nonnull MessageEncoder encoder) {
        this.messageEncoder = (MessageEncoder)Constraint.isNotNull((Object)encoder, (String)"The message encoder cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.messageEncoder == null) {
            throw new ComponentInitializationException("The message encoder cannot be null");
        }
    }

    @Override
    @Nullable
    public MessageEncoder apply(@Nullable ProfileRequestContext input) {
        MessageContext messageContext;
        MessageContext messageContext2 = messageContext = input != null ? input.getOutboundMessageContext() : null;
        if (messageContext == null) {
            this.log.error("No outbound message context available");
            return null;
        }
        Object message = messageContext.getMessage();
        if (message == null || !(message instanceof Response)) {
            this.log.error("Unexpected message in the outbound message context: {}", message);
        }
        return this.messageEncoder;
    }
}

