/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.authn.audit.impl;

import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.auth.JWTAuthentication;
import java.text.ParseException;
import java.util.Date;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.oidc.authn.context.OAuth2ClientAuthenticationContext;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class ClientAuthenticationJWTPayloadClaimsAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private Function<ProfileRequestContext, OAuth2ClientAuthenticationContext> clientAuthContextLookupStrategy;
    @Nonnull
    @NotEmpty
    private final String key;

    public ClientAuthenticationJWTPayloadClaimsAuditExtractor(@Nonnull @ParameterName(name="key") @NotEmpty String claim) {
        this.key = Constraint.isNotEmpty((String)claim, (String)"The claim cannot be empty");
        Function cacls = new ChildContextLookup(OAuth2ClientAuthenticationContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));
        assert (cacls != null);
        this.clientAuthContextLookupStrategy = cacls;
    }

    public ClientAuthenticationJWTPayloadClaimsAuditExtractor(@Nonnull @ParameterName(name="key") @NotEmpty String claim, @Nonnull @ParameterName(name="clientAuthContextLookupStrategy") Function<ProfileRequestContext, OAuth2ClientAuthenticationContext> lookupStrategy) {
        this.key = Constraint.isNotEmpty((String)claim, (String)"key cannot be empty");
        this.clientAuthContextLookupStrategy = (Function)Constraint.isNotNull(lookupStrategy, (String)"clientAuthContextLookupStrategy lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        SignedJWT jwt = Optional.ofNullable(this.clientAuthContextLookupStrategy.apply(input)).map(ctx -> ctx.getClientAuthentication()).filter(JWTAuthentication.class::isInstance).map(JWTAuthentication.class::cast).map(jwtAuthentication -> jwtAuthentication.getClientAssertion()).orElse(null);
        try {
            Object claim;
            Object object = claim = jwt == null ? null : jwt.getJWTClaimsSet().getClaim(this.key);
            if (claim instanceof Date) {
                Date date = (Date)claim;
                return date.toInstant().toString();
            }
            if (claim != null) {
                return claim.toString();
            }
            return null;
        }
        catch (ParseException e) {
            return null;
        }
    }
}

