/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.security.jwt.claims.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class DefaultDPoPProofNonceGenerator
extends AbstractIdentifiableInitializableComponent
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultDPoPProofNonceGenerator.class);
    @Nonnull
    private final DataSealer dataSealer;
    @NonnullAfterInit
    private ObjectMapper objectMapper;
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> relyingPartyIdLookupStrategy;
    @Nonnull
    private Duration nonceLifetime;

    public DefaultDPoPProofNonceGenerator(@Nonnull @ParameterName(name="sealer") DataSealer sealer) {
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"Data sealer cannot be null");
        Duration fiveMins = Duration.ofMinutes(5L);
        assert (fiveMins != null);
        this.nonceLifetime = fiveMins;
        this.idGeneratorLookupStrategy = FunctionSupport.constant((Object)new SecureRandomIdentifierGenerationStrategy());
        this.relyingPartyIdLookupStrategy = new RelyingPartyIdLookupFunction();
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    public void setNonceLifetime(@Nonnull Duration duration) {
        this.checkSetterPreconditions();
        Constraint.isTrue((!duration.isZero() && !duration.isNegative() ? 1 : 0) != 0, (String)"Nonce lifetime must be greater than 0");
        this.nonceLifetime = duration;
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        this.checkSetterPreconditions();
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Identifier generation strategy cannot be null");
    }

    public void setRelyingPartyIdLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyIdLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Relying party ID lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext profileRequestContext) {
        IdentifierGenerationStrategy idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
        if (idGenerator == null) {
            this.log.error("Could not resolve idGenerator");
            return null;
        }
        String rpId = this.relyingPartyIdLookupStrategy.apply(profileRequestContext);
        if (rpId == null) {
            this.log.error("Could not resolve relying party ID");
            return null;
        }
        String id = idGenerator.generateIdentifier(false);
        Instant nonceExp = Instant.now().plus(this.nonceLifetime);
        Map<String, String> map = Map.of("jti", id, "exp", "" + nonceExp.toEpochMilli(), "rpId", rpId);
        try {
            String raw = this.objectMapper.writeValueAsString(map);
            if (raw != null) {
                String nonce = this.dataSealer.wrap(raw, nonceExp.plus(Duration.ofMinutes(5L)));
                this.log.debug("Successfully generated a new nonce {}", (Object)nonce);
                return nonce;
            }
            this.log.error("Could not encode nonce map into a JSON string");
        }
        catch (JsonProcessingException | DataSealerException e) {
            this.log.error("Could not create a new nonce", e);
        }
        return null;
    }
}

