/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.spring;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.token.support.RefreshTokenClaimsSet;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;

public class TokenExtensionFactory
implements ApplicationContextAware {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(TokenExtensionFactory.class);
    private ApplicationContext applicationContext;
    @Nonnull
    private final String beanId;
    @Nonnull
    private final ResolvableType extensionType;
    private final boolean allowNonPrototype;

    public TokenExtensionFactory(@Nonnull @ParameterName(name="id") String id, @Nonnull @ParameterName(name="tokenExtensionType") TokenExtensionType tokenExtensionType, @ParameterName(name="allowNonPrototype") boolean nonPrototype) {
        this.beanId = Constraint.isNotEmpty((String)id, (String)"Bean id cannot be empty");
        Constraint.isNotNull((Object)((Object)tokenExtensionType), (String)"Token extension type cannot be null");
        ParameterizedTypeReference typeReference = switch (tokenExtensionType) {
            default -> throw new IncompatibleClassChangeError();
            case TokenExtensionType.REFRESH_TOKEN_SERIALIZER -> new ParameterizedTypeReference<BiFunction<ProfileRequestContext, RefreshTokenClaimsSet, String>>(){};
            case TokenExtensionType.REFRESH_TOKEN_DESERIALIZER -> new ParameterizedTypeReference<BiFunction<ProfileRequestContext, String, RefreshTokenClaimsSet>>(){};
            case TokenExtensionType.PAR_REQUEST_URI_SERIALIZER -> new ParameterizedTypeReference<BiFunction<ProfileRequestContext, Map<String, Object>, URI>>(){};
            case TokenExtensionType.PAR_REQUEST_URI_DESERIALIZER -> new ParameterizedTypeReference<BiFunction<ProfileRequestContext, URI, Map<String, Object>>>(){};
        };
        this.extensionType = ResolvableType.forType((ParameterizedTypeReference)typeReference);
        this.allowNonPrototype = nonPrototype;
    }

    @Nullable
    public Object getBean() {
        this.log.trace("Looking for bean {}: exists={}, isPrototype={}, isSingleton={}", new Object[]{this.beanId, this.applicationContext.containsBean(this.beanId), this.applicationContext.isPrototype(this.beanId), this.applicationContext.isSingleton(this.beanId)});
        String[] compatibleBeans = this.applicationContext.getBeanNamesForType(this.extensionType);
        if (compatibleBeans.length == 0) {
            this.log.warn("No compatible beans with type {} found", (Object)this.extensionType);
            return null;
        }
        if (List.of(compatibleBeans).contains(this.beanId)) {
            if (!this.applicationContext.isPrototype(this.beanId) && !this.allowNonPrototype) {
                this.log.error("The bean {} is not prototype which is not allowed", (Object)this.beanId);
                return null;
            }
            return this.applicationContext.getBean(this.beanId);
        }
        this.log.warn("The bean {} is not compatible with type {}", (Object)this.beanId, (Object)this.extensionType);
        return null;
    }

    public void setApplicationContext(@Nonnull ApplicationContext context) throws BeansException {
        this.applicationContext = context;
    }

    public static enum TokenExtensionType {
        REFRESH_TOKEN_SERIALIZER,
        REFRESH_TOKEN_DESERIALIZER,
        PAR_REQUEST_URI_SERIALIZER,
        PAR_REQUEST_URI_DESERIALIZER;

    }
}

