/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultOIDCMetadataContextLookupFunction;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class MetadataValueEqualsCondition
extends AbstractIdentifiableInitializableComponent
implements Predicate<ProfileRequestContext> {
    @Nonnull
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcMetadataContextLookupStrategy = new DefaultOIDCMetadataContextLookupFunction();
    @NonnullAfterInit
    private String metadataKey;
    @NonnullAfterInit
    private Object metadataValue;
    @Nullable
    private Object defaultValue;

    public void setOidcMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCMetadataContext> strategy) {
        this.checkSetterPreconditions();
        this.oidcMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setKey(@Nonnull String key) {
        this.checkSetterPreconditions();
        this.metadataKey = Constraint.isNotEmpty((String)key, (String)"Key value cannot be empty");
    }

    public void setValue(@Nonnull Object value) {
        this.checkSetterPreconditions();
        this.metadataValue = Constraint.isNotNull((Object)value, (String)"Value cannot be empty");
    }

    public void setDefaultValue(@Nullable Object value) {
        this.checkSetterPreconditions();
        this.defaultValue = value;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (StringSupport.trimOrNull((String)this.metadataKey) == null) {
            throw new ComponentInitializationException("Key value cannot be empty");
        }
        if (this.metadataValue == null) {
            throw new ComponentInitializationException("Value cannot be empty");
        }
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        OIDCClientInformation clientInformation;
        OIDCMetadataContext oidcMetadataCtx = this.oidcMetadataContextLookupStrategy.apply(input);
        if (oidcMetadataCtx != null && (clientInformation = oidcMetadataCtx.getClientInformation()) != null && clientInformation.getOIDCMetadata() != null) {
            Object value = clientInformation.getOIDCMetadata().toJSONObject().get((Object)this.metadataKey);
            return this.metadataValue.equals(value != null ? value : this.defaultValue);
        }
        return false;
    }
}

