/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class MetadataPolicyRedirectUriValidator
extends AbstractIdentifiableInitializableComponent
implements BiPredicate<URI, ProfileRequestContext> {
    @NonnullAfterInit
    private BiFunction<Object, MetadataPolicy, Pair<Object, Boolean>> metadataPolicyEnforcer;
    @NonnullAfterInit
    private Predicate<Map<String, MetadataPolicy>> metadataPolicyValidator;
    @NonnullAfterInit
    private MetadataPolicy metadataPolicy;

    public void setMetadataPolicyEnforcer(@Nonnull BiFunction<Object, MetadataPolicy, Pair<Object, Boolean>> enforcer) {
        this.checkSetterPreconditions();
        this.metadataPolicyEnforcer = (BiFunction)Constraint.isNotNull(enforcer, (String)"Metadata policy enforcer cannot be null");
    }

    public void setMetadataPolicyValidator(@Nonnull Predicate<Map<String, MetadataPolicy>> validator) {
        this.checkSetterPreconditions();
        this.metadataPolicyValidator = (Predicate)Constraint.isNotNull(validator, (String)"Metadata policy validator cannot be null");
    }

    public void setMetadataPolicy(@Nonnull MetadataPolicy policy) {
        this.checkSetterPreconditions();
        this.metadataPolicy = (MetadataPolicy)Constraint.isNotNull((Object)policy, (String)"Metadata policy cannot be null");
    }

    public void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.metadataPolicyEnforcer == null) {
            throw new ComponentInitializationException("Metadata policy enforcer cannot be null");
        }
        if (this.metadataPolicyValidator == null) {
            throw new ComponentInitializationException("Metadata policy validator cannot be null");
        }
        if (this.metadataPolicy == null) {
            throw new ComponentInitializationException("Metadata policy cannot be null");
        }
        if (!this.metadataPolicyValidator.test(Map.of("redirect_uri", this.metadataPolicy))) {
            throw new ComponentInitializationException("Metadata policy didn't pass the validation");
        }
    }

    @Override
    public boolean test(@Nullable URI uri, @Nullable ProfileRequestContext profileRequestContext) {
        Pair<Object, Boolean> enforcerResult = this.metadataPolicyEnforcer.apply(uri == null ? null : uri.toString(), this.metadataPolicy);
        return enforcerResult != null && Optional.of((Boolean)enforcerResult.getSecond()).orElse(Boolean.FALSE) != false;
    }
}

