/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import com.nimbusds.jwt.JWTClaimsSet;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultTokenRevocationLifetimeLookupStrategy
implements Function<JWTClaimsSet, Duration> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultTokenRevocationLifetimeLookupStrategy.class);
    @Nonnull
    private Duration clockSkew;

    public DefaultTokenRevocationLifetimeLookupStrategy() {
        Duration skew = Duration.ofMinutes(5L);
        assert (skew != null);
        this.clockSkew = skew;
    }

    public void setClockSkew(@Nonnull Duration skew) {
        Duration newValue = ((Duration)Constraint.isNotNull((Object)skew, (String)"Clock skew cannot be null")).abs();
        assert (newValue != null);
        this.clockSkew = newValue;
    }

    @Override
    @Nullable
    public Duration apply(@Nullable JWTClaimsSet claimsSet) {
        Instant exp;
        if (claimsSet == null) {
            this.log.error("The given claims set was null, returning null");
            return null;
        }
        Date expiration = claimsSet.getExpirationTime();
        if (expiration == null) {
            this.log.debug("No token expiration time found from the claims set, returning null");
            return null;
        }
        Instant now = Instant.now();
        if (now.isAfter((exp = expiration.toInstant()).plus(this.clockSkew))) {
            this.log.debug("Token expiration time was in the past, returning ZERO");
            return Duration.ZERO;
        }
        return Duration.between(now, exp).abs().plus(Duration.ofMinutes(5L)).plus(this.clockSkew);
    }
}

