/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.impl.MetadataPolicyHelper;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultMetadataPolicyMergingStrategy
implements BiFunction<Map<String, MetadataPolicy>, Map<String, MetadataPolicy>, Pair<Map<String, MetadataPolicy>, Boolean>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultMetadataPolicyMergingStrategy.class);

    @Override
    @Nonnull
    public Pair<Map<String, MetadataPolicy>, Boolean> apply(@Nullable Map<String, MetadataPolicy> first, @Nullable Map<String, MetadataPolicy> second) {
        if (first == null || first.isEmpty()) {
            return new Pair(second == null ? (first == null ? null : Collections.emptyMap()) : second, (Object)Boolean.TRUE);
        }
        if (second == null || second.isEmpty()) {
            return new Pair(first, (Object)Boolean.TRUE);
        }
        Set combinedKeys = Stream.concat(first.keySet().stream(), second.keySet().stream()).collect(Collectors.toSet());
        HashMap<String, MetadataPolicy> result = new HashMap<String, MetadataPolicy>();
        boolean valid = true;
        for (String key : combinedKeys) {
            try {
                result.put(key, MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)first.get(key), (MetadataPolicy)second.get(key)));
            }
            catch (ConstraintViolationException e) {
                this.log.warn("Incompatible metadata policies for claim '{}' that cannot be merged.", (Object)key);
                valid = false;
            }
        }
        return new Pair(result, (Object)valid);
    }
}

