/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.text.ParseException;
import java.util.Date;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.encoding.impl.ResponseUtil;
import net.shibboleth.idp.plugin.oidc.op.token.support.RefreshTokenClaimsSet;
import net.shibboleth.oidc.security.impl.JWSTokenSigner;
import net.shibboleth.oidc.security.jose.SignatureException;
import net.shibboleth.oidc.security.jose.SignatureSigningParameters;
import net.shibboleth.oidc.security.jose.context.SecurityParametersContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class DefaultJwtRefreshTokenSerializationFunction
extends AbstractInitializableComponent
implements BiFunction<ProfileRequestContext, RefreshTokenClaimsSet, String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultJwtRefreshTokenSerializationFunction.class);
    @Nonnull
    private Logger protocolMessageLog = LoggerFactory.getLogger((String)"PROTOCOL_MESSAGE.OAUTH2");
    @NonnullAfterInit
    private DataSealer dataSealer;
    @Nonnull
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersContextLookupStrategy;
    @NonnullAfterInit
    MessageHandler signingParametersHandler;
    @NonnullAfterInit
    private BiFunction<ProfileRequestContext, RefreshTokenClaimsSet, String> typeHeaderLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> audienceLookupStrategy;
    @NonnullAfterInit
    private ObjectMapper objectMapper;

    public DefaultJwtRefreshTokenSerializationFunction() {
        Function spcls = new ChildContextLookup(SecurityParametersContext.class, true).compose((Function)new InboundMessageContextLookup());
        assert (spcls != null);
        this.securityParametersContextLookupStrategy = spcls;
    }

    public void setDataSealer(@Nonnull DataSealer sealer) {
        this.checkSetterPreconditions();
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"Data sealer cannot be null");
    }

    public void setSecurityParametersContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        this.checkSetterPreconditions();
        this.securityParametersContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"The security parameters context lookup strategy cannot be null");
    }

    public void setSigningParametersHandler(@Nonnull MessageHandler handler) {
        this.checkSetterPreconditions();
        this.signingParametersHandler = (MessageHandler)Constraint.isNotNull((Object)handler, (String)"The signing parameters handler cannot be null");
    }

    public void setTypeHeaderLookupStrategy(@Nonnull BiFunction<ProfileRequestContext, RefreshTokenClaimsSet, String> strategy) {
        this.checkSetterPreconditions();
        this.typeHeaderLookupStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"The type header lookup strategy cannot be null");
    }

    public void setAudienceLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.audienceLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Audience lookup strategy can not be null");
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.dataSealer == null) {
            throw new ComponentInitializationException("The dat sealer cannot be null");
        }
        if (this.signingParametersHandler == null) {
            throw new ComponentInitializationException("The signing parameters handler cannot be null");
        }
        if (this.typeHeaderLookupStrategy == null) {
            throw new ComponentInitializationException("The type header lookup strategy cannot be null");
        }
        if (this.audienceLookupStrategy == null) {
            throw new ComponentInitializationException("The audience lookup strategy cannot be null)");
        }
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("Object mapper cannot be null");
        }
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext profileRequestContext, @Nullable RefreshTokenClaimsSet claimsSet) {
        if (profileRequestContext == null || profileRequestContext.getInboundMessageContext() == null) {
            this.log.error("Could not find inbound message context");
            return null;
        }
        if (claimsSet == null) {
            this.log.error("Given refresh token claims set was null");
            return null;
        }
        MessageContext messageContext = profileRequestContext.getInboundMessageContext();
        assert (messageContext != null);
        try {
            this.signingParametersHandler.invoke(messageContext);
        }
        catch (MessageHandlerException e) {
            this.log.error("Could not populate signing parameters", (Throwable)e);
            return null;
        }
        SecurityParametersContext securityContext = this.securityParametersContextLookupStrategy.apply(profileRequestContext);
        if (securityContext == null || securityContext.getSignatureSigningParameters() == null) {
            this.log.error("Could not find signature signing parameters context after population");
            return null;
        }
        SignatureSigningParameters signingParameters = securityContext.getSignatureSigningParameters();
        assert (signingParameters != null);
        String typeHeader = this.typeHeaderLookupStrategy.apply(profileRequestContext, claimsSet);
        String audience = this.audienceLookupStrategy.apply(profileRequestContext);
        if (audience == null) {
            this.log.error("Could not resolve audience for the JWT");
            return null;
        }
        SignedJWT jwt = this.constructJWT(claimsSet, audience, signingParameters, typeHeader);
        return jwt != null ? jwt.serialize() : null;
    }

    @Nullable
    protected SignedJWT constructJWT(@Nonnull RefreshTokenClaimsSet claimsSet, @Nonnull String audience, @Nonnull SignatureSigningParameters signingParameters, @Nullable String typeHeader) {
        JWTClaimsSet jwtClaims;
        String jti = claimsSet.getID();
        if (jti == null) {
            this.log.error("No ID was set in the claims set");
            return null;
        }
        ClientID clientId = claimsSet.getClientID();
        if (clientId == null || clientId.getValue() == null) {
            this.log.error("No clientID was set in the claims set");
            return null;
        }
        try {
            assert (this.dataSealer != null);
            String sealedClaim = claimsSet.serialize(this.dataSealer);
            jwtClaims = new JWTClaimsSet.Builder().issuer(claimsSet.getIssuer()).audience(audience).issueTime(Date.from(claimsSet.getIssuedAt())).expirationTime(Date.from(claimsSet.getExp())).jwtID(jti).claim("client_id", (Object)clientId.getValue()).claim("for_op", (Object)sealedClaim).build();
        }
        catch (DataSealerException e) {
            this.log.error("Could not encrypt the {} claim", (Object)"for_op", (Object)e);
            return null;
        }
        assert (jwtClaims != null);
        JWSTokenSigner signer = new JWSTokenSigner(signingParameters);
        try {
            assert (this.objectMapper != null);
            this.protocolMessageLog.trace("JWT refresh token payload contents:\n{}", (Object)ResponseUtil.getJwtProtocolMessage(jwtClaims, this.objectMapper));
        }
        catch (ParseException e) {
            this.log.error("Could not construct the protocol message of the JWT contents", (Throwable)e);
        }
        try {
            return signer.sign(jwtClaims, typeHeader);
        }
        catch (SignatureException e) {
            this.log.error("Could not sign the JWT", (Throwable)e);
            return null;
        }
    }
}

