/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import java.time.Duration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.config.navigate.RevocationLifetimeLookupFunction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class DefaultChainRevocationLifetimeLookupStrategy
extends RevocationLifetimeLookupFunction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultChainRevocationLifetimeLookupStrategy.class);
    @Nonnull
    private Duration clockSkew;

    public DefaultChainRevocationLifetimeLookupStrategy() {
        Duration skew = Duration.ofMinutes(5L);
        assert (skew != null);
        this.clockSkew = skew;
    }

    public void setClockSkew(@Nonnull Duration skew) {
        Duration newValue = ((Duration)Constraint.isNotNull((Object)skew, (String)"Clock skew cannot be null")).abs();
        assert (newValue != null);
        this.clockSkew = newValue;
    }

    @Nullable
    public Duration apply(@Nullable ProfileRequestContext input) {
        Duration profileDuration = super.apply(input);
        if (profileDuration == null || profileDuration.isZero()) {
            this.log.debug("No chain expiration time could be resolved, returning null");
            return null;
        }
        return profileDuration.plus(Duration.ofMinutes(5L)).plus(this.clockSkew);
    }
}

