/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class DPoPAccessTokenInRequestCondition
extends AbstractIdentifiableInitializableComponent
implements Predicate<ProfileRequestContext> {
    @NonnullAfterInit
    private Supplier<HttpServletRequest> httpServletRequestSupplier;

    public void setHttpServletRequestSupplier(@Nonnull Supplier<HttpServletRequest> supplier) {
        this.httpServletRequestSupplier = (Supplier)Constraint.isNotNull(supplier, (String)"Http servlet request supplier cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpServletRequestSupplier == null) {
            throw new ComponentInitializationException("Http servlet request supplier cannot be null");
        }
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        this.checkComponentActive();
        HttpServletRequest httpServletRequest = this.httpServletRequestSupplier.get();
        if (httpServletRequest == null) {
            return false;
        }
        Enumeration authorizationHeaders = httpServletRequest.getHeaders("Authorization");
        if (authorizationHeaders == null) {
            return false;
        }
        while (authorizationHeaders.hasMoreElements()) {
            if (!((String)authorizationHeaders.nextElement()).startsWith("DPoP ")) continue;
            return true;
        }
        return false;
    }
}

