/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationResponseAction;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class VerifyRequestedSubjectIdentifier
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(VerifyRequestedSubjectIdentifier.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        String requestedSubject = oidcResponseContext.getRequestedSubject();
        String generatedSubject = oidcResponseContext.getSubject();
        if (requestedSubject == null) {
            this.log.debug("{} No requested subject, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        if (!requestedSubject.equals(generatedSubject)) {
            this.log.error("{} client requested for subject {}, the produced subject is {}, mismatch", new Object[]{this.getLogPrefix(), requestedSubject, generatedSubject});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
            return;
        }
        this.log.debug("{} Requested subject matched the generated subject {}", (Object)this.getLogPrefix(), (Object)generatedSubject);
    }
}

