/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jose.util.Base64URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate.DefaultRequestCodeVerifierLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.oidc.profile.config.logic.AllowPKCEPlainPredicate;
import net.shibboleth.oidc.profile.config.logic.ForcePKCEPredicate;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidatePKCE
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidatePKCE.class);
    @Nonnull
    private Function<ProfileRequestContext, String> codeVerifierLookupStrategy = new DefaultRequestCodeVerifierLookupFunction();
    @Nonnull
    private Predicate<ProfileRequestContext> forcePKCECondition = new ForcePKCEPredicate();
    @Nonnull
    private Predicate<ProfileRequestContext> allowPKCEPlainCondition = new AllowPKCEPlainPredicate();
    private boolean forcePKCE;
    private boolean plainPKCE;
    @Nullable
    private String codeChallenge;
    @Nullable
    private String codeVerifier;

    public void setForcePKCECondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.forcePKCECondition = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public void setAllowPKCEPlainCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.allowPKCEPlainCondition = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    public void setCodeVerifierLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.codeVerifierLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"CodeVerifier lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        if (oidcResponseContext.getAuthorizationGrantClaimsSet() == null) {
            this.log.warn("{} No validated authorization grant claims set available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        TokenClaimsSet tokenClaimsSet = oidcResponseContext.getAuthorizationGrantClaimsSet();
        assert (tokenClaimsSet != null);
        if (!"ac".equals(tokenClaimsSet.getType())) {
            this.log.debug("{} No authorization code presented, PKCE not applied, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.forcePKCE = this.forcePKCECondition.test(profileRequestContext);
        this.plainPKCE = this.allowPKCEPlainCondition.test(profileRequestContext);
        this.codeChallenge = tokenClaimsSet.getCodeChallenge();
        if (StringSupport.trimOrNull((String)this.codeChallenge) == null && !this.forcePKCE) {
            this.log.debug("{} No PKCE code challenge in request, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.codeVerifier = this.codeVerifierLookupStrategy.apply(profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (StringSupport.trimOrNull((String)this.codeChallenge) == null) {
            this.log.warn("{} No PKCE code challenge presented in authentication request even though required to access token endpoint", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        String nonNullChallenge = this.codeChallenge;
        assert (nonNullChallenge != null);
        if (StringSupport.trimOrNull((String)this.codeVerifier) == null) {
            this.log.warn("{} No PKCE code verifier for code challenge presented in token request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        String nonNullVerifier = this.codeVerifier;
        assert (nonNullVerifier != null);
        if (nonNullChallenge.startsWith("plain")) {
            if (!this.plainPKCE) {
                this.log.warn("{} Plain PKCE code challenge method not allowed", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
            String codeChallengeValue = nonNullChallenge.substring("plain".length());
            if (!nonNullVerifier.equals(codeChallengeValue)) {
                this.log.warn("{} PKCE code challenge {} not matching code verifier {}", new Object[]{this.getLogPrefix(), codeChallengeValue, this.codeVerifier});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageAuthenticationError");
                return;
            }
        } else if (nonNullChallenge.startsWith("S256")) {
            String codeChallengeValue = nonNullChallenge.substring("S256".length());
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                this.log.warn("{} PKCE S256 code challenge verification requires SHA-256", new Object[]{this.getLogPrefix(), codeChallengeValue, this.codeVerifier});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageAuthenticationError");
                return;
            }
            byte[] hash = md.digest(nonNullVerifier.getBytes(Charset.forName("utf-8")));
            String codeChallengeComparisonValue = Base64URL.encode((byte[])hash).toString();
            if (!codeChallengeComparisonValue.equals(codeChallengeValue)) {
                this.log.warn("{} PKCE code challenge {} not matching code verifier {}({})", new Object[]{this.getLogPrefix(), codeChallengeValue, this.codeVerifier, codeChallengeComparisonValue});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageAuthenticationError");
                return;
            }
        } else {
            this.log.warn("{} Unknown code challenge method", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
    }
}

