/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCTokenResponseAction;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.oidc.profile.config.navigate.GrantTypesLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateGrantType
extends AbstractOIDCTokenResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateGrantType.class);
    @Nonnull
    private Function<ProfileRequestContext, Set<GrantType>> grantTypesLookupStrategy = new GrantTypesLookupFunction();
    @Nullable
    @NonnullElements
    private Set<GrantType> enabledTypes;

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.enabledTypes = this.grantTypesLookupStrategy.apply(profileRequestContext);
        if (this.enabledTypes == null) {
            this.enabledTypes = Collections.emptySet();
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCClientInformation clientInformation;
        OIDCMetadataContext metadataCtx = this.getMetadataContext();
        Set registeredTypes = metadataCtx != null ? ((clientInformation = metadataCtx.getClientInformation()) != null && clientInformation.getMetadata() != null ? clientInformation.getMetadata().getGrantTypes() : null) : null;
        AuthorizationGrant grant = this.getTokenRequest().getAuthorizationGrant();
        if (registeredTypes != null && !registeredTypes.contains(grant.getType())) {
            this.log.error("{} Grant type {} not registered for client", (Object)this.getLogPrefix(), (Object)grant.getType().getValue());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrantType");
        } else {
            assert (this.enabledTypes != null);
            if (!this.enabledTypes.contains(grant.getType())) {
                this.log.error("{} Grant type {} not enabled in profile configuration", (Object)this.getLogPrefix(), (Object)grant.getType().getValue());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrantType");
            }
        }
    }
}

