/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.text.ParseException;
import java.time.Instant;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.navigate.TokenRequestClientIDLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCTokenResponseAction;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.RefreshTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class UnwrapGrant
extends AbstractOIDCTokenResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(UnwrapGrant.class);
    @Nonnull
    private final DataSealer dataSealer;
    @Nonnull
    private Function<MessageContext, ClientID> clientIDLookupStrategy;
    @Nonnull
    private List<BiFunction<ProfileRequestContext, String, RefreshTokenClaimsSet>> refreshTokenDeserializers;

    public UnwrapGrant(@Nonnull @ParameterName(name="sealer") DataSealer sealer) {
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
        this.refreshTokenDeserializers = CollectionSupport.emptyList();
        this.clientIDLookupStrategy = new TokenRequestClientIDLookupFunction();
    }

    public void setRefreshTokenDeserializers(@Nonnull List<BiFunction<ProfileRequestContext, String, RefreshTokenClaimsSet>> deserializers) {
        this.checkSetterPreconditions();
        this.refreshTokenDeserializers = (List)Constraint.isNotNull(deserializers, (String)"List of refresh token deserializers cannot be null");
    }

    public void setClientIDLookupStrategy(@Nonnull Function<MessageContext, ClientID> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.clientIDLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ClientIDLookupStrategy lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AuthorizationGrant grant = this.getTokenRequest().getAuthorizationGrant();
        this.log.debug("{} Unwrapping grant type: {}", (Object)this.getLogPrefix(), (Object)grant.getType());
        RefreshTokenClaimsSet tokenClaimsSet = null;
        if (GrantType.AUTHORIZATION_CODE.equals((Object)grant.getType())) {
            AuthorizationCodeGrant codeGrant = (AuthorizationCodeGrant)grant;
            if (codeGrant.getAuthorizationCode() != null && codeGrant.getAuthorizationCode().getValue() != null) {
                try {
                    String codeValue = codeGrant.getAuthorizationCode().getValue();
                    assert (codeValue != null);
                    AuthorizeCodeClaimsSet authzCodeClaimsSet = AuthorizeCodeClaimsSet.parse((String)codeValue, (DataSealer)this.dataSealer);
                    assert (authzCodeClaimsSet != null);
                    String jti = authzCodeClaimsSet.getID();
                    if (jti == null) {
                        this.log.warn("{} Invalid contents in the authz code grant: no JTI", (Object)this.getLogPrefix());
                        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                        return;
                    }
                    this.log.debug("{} Authz code unwrapped {}", (Object)this.getLogPrefix(), (Object)authzCodeClaimsSet.serialize());
                    tokenClaimsSet = authzCodeClaimsSet;
                }
                catch (ParseException | DataSealerException e) {
                    this.log.warn("{} Unwrapping authz code failed: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                    return;
                }
            }
        } else if (GrantType.REFRESH_TOKEN.equals((Object)grant.getType())) {
            RefreshTokenGrant refreshTokentokenGrant = (RefreshTokenGrant)grant;
            if (refreshTokentokenGrant.getRefreshToken() != null && refreshTokentokenGrant.getRefreshToken().getValue() != null) {
                String tokenValue = refreshTokentokenGrant.getRefreshToken().getValue();
                assert (tokenValue != null);
                RefreshTokenClaimsSet refreshTokenClaimsSet = this.deserializeRefreshToken(profileRequestContext, tokenValue);
                if (refreshTokenClaimsSet == null) {
                    this.log.warn("{} Unwrapping refresh token failed", (Object)this.getLogPrefix());
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                    return;
                }
                Instant chainExp = refreshTokenClaimsSet.getChainExp();
                if (chainExp != null && chainExp.isBefore(Instant.now())) {
                    this.log.warn("{} Refresh token chain has expired on {}", (Object)this.getLogPrefix(), (Object)refreshTokenClaimsSet.getChainExp());
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                    return;
                }
                tokenClaimsSet = refreshTokenClaimsSet;
            }
        } else if (GrantType.CLIENT_CREDENTIALS.equals((Object)grant.getType())) {
            return;
        }
        if (tokenClaimsSet == null) {
            this.log.warn("{} Grant type not supported", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        if (!tokenClaimsSet.isTimeValid()) {
            this.log.warn("{} Token is expired or not net valid", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        ClientID clientId = tokenClaimsSet.getClientID();
        assert (clientId != null);
        ClientID requestClientId = this.clientIDLookupStrategy.apply(profileRequestContext.ensureInboundMessageContext());
        if (!clientId.equals((Object)requestClientId)) {
            this.log.warn("{} Token issued to client {}, invalid for {}", new Object[]{this.getLogPrefix(), clientId.getValue(), requestClientId});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        oidcResponseContext.setAuthorizationGrantClaimsSet((TokenClaimsSet)tokenClaimsSet);
    }

    protected RefreshTokenClaimsSet deserializeRefreshToken(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull String refreshToken) {
        try {
            return RefreshTokenClaimsSet.parse((String)refreshToken, (DataSealer)this.dataSealer);
        }
        catch (ParseException | DataSealerException throwable) {
            for (BiFunction<ProfileRequestContext, String, RefreshTokenClaimsSet> deserializer : this.refreshTokenDeserializers) {
                RefreshTokenClaimsSet deserializedSet = deserializer.apply(profileRequestContext, refreshToken);
                if (deserializedSet == null) continue;
                return deserializedSet;
            }
            return null;
        }
    }
}

